/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aws.sdk.v2.client.apache;

import io.micronaut.aws.sdk.v2.client.apache.ApacheClientConfiguration;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requires;
import jakarta.inject.Singleton;
import software.amazon.awssdk.http.SdkHttpClient;

@BootstrapContextCompatible
@Factory
public class ApacheClientFactory {
    public static final String APACHE_SDK_HTTP_SERVICE = "software.amazon.awssdk.http.apache.ApacheSdkHttpService";

    @Bean(preDestroy="close")
    @Singleton
    @Requires(property="software.amazon.awssdk.http.service.impl", notEquals="software.amazon.awssdk.http.urlconnection.UrlConnectionSdkHttpService")
    public SdkHttpClient apacheClient(ApacheClientConfiguration configuration) {
        return this.doCreateClient(configuration);
    }

    @Bean(preDestroy="close")
    @Singleton
    @Requires(property="software.amazon.awssdk.http.service.impl", value="software.amazon.awssdk.http.apache.ApacheSdkHttpService")
    public SdkHttpClient systemPropertyClient(ApacheClientConfiguration configuration) {
        return this.doCreateClient(configuration);
    }

    private SdkHttpClient doCreateClient(ApacheClientConfiguration configuration) {
        return configuration.getBuilder().build();
    }
}

