/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aws.sdk.v2.service.cloudwatchlogs;

import io.micronaut.aws.sdk.v2.service.AwsClientFactory;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requires;
import jakarta.inject.Singleton;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.regions.providers.AwsRegionProviderChain;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsAsyncClient;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsAsyncClientBuilder;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClientBuilder;

@Factory
@BootstrapContextCompatible
public class CloudwatchLogsClientFactory
extends AwsClientFactory<CloudWatchLogsClientBuilder, CloudWatchLogsAsyncClientBuilder, CloudWatchLogsClient, CloudWatchLogsAsyncClient> {
    protected CloudwatchLogsClientFactory(AwsCredentialsProviderChain credentialsProvider, AwsRegionProviderChain regionProvider) {
        super(credentialsProvider, regionProvider);
    }

    @Override
    protected CloudWatchLogsClientBuilder createSyncBuilder() {
        return CloudWatchLogsClient.builder();
    }

    @Override
    protected CloudWatchLogsAsyncClientBuilder createAsyncBuilder() {
        return CloudWatchLogsAsyncClient.builder();
    }

    @Override
    @Singleton
    public CloudWatchLogsClientBuilder syncBuilder(SdkHttpClient httpClient) {
        return (CloudWatchLogsClientBuilder)super.syncBuilder(httpClient);
    }

    @Override
    @Bean(preDestroy="close")
    @Singleton
    public CloudWatchLogsClient syncClient(CloudWatchLogsClientBuilder builder) {
        return (CloudWatchLogsClient)super.syncClient(builder);
    }

    @Override
    @Singleton
    @Requires(beans={SdkAsyncHttpClient.class})
    public CloudWatchLogsAsyncClientBuilder asyncBuilder(SdkAsyncHttpClient httpClient) {
        return (CloudWatchLogsAsyncClientBuilder)super.asyncBuilder(httpClient);
    }

    @Override
    @Bean(preDestroy="close")
    @Singleton
    @Requires(beans={SdkAsyncHttpClient.class})
    public CloudWatchLogsAsyncClient asyncClient(CloudWatchLogsAsyncClientBuilder builder) {
        return (CloudWatchLogsAsyncClient)super.asyncClient(builder);
    }
}

