/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aws.sdk.v2.service.secretsmanager;

import io.micronaut.aws.sdk.v2.service.AWSServiceConfiguration;
import io.micronaut.aws.sdk.v2.service.AwsClientFactory;
import io.micronaut.aws.ua.UserAgentProvider;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.regions.providers.AwsRegionProviderChain;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerAsyncClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerAsyncClientBuilder;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;

@Factory
@BootstrapContextCompatible
public class SecretsManagerClientFactory
extends AwsClientFactory<SecretsManagerClientBuilder, SecretsManagerAsyncClientBuilder, SecretsManagerClient, SecretsManagerAsyncClient> {
    protected SecretsManagerClientFactory(AwsCredentialsProviderChain credentialsProvider, AwsRegionProviderChain regionProvider, @Nullable UserAgentProvider userAgentProvider, @Nullable @Named(value="secretsmanager") AWSServiceConfiguration awsServiceConfiguration) {
        super(credentialsProvider, regionProvider, userAgentProvider, awsServiceConfiguration);
    }

    @Override
    protected SecretsManagerClientBuilder createSyncBuilder() {
        return SecretsManagerClient.builder();
    }

    @Override
    protected SecretsManagerAsyncClientBuilder createAsyncBuilder() {
        return SecretsManagerAsyncClient.builder();
    }

    @Override
    @Singleton
    public SecretsManagerClientBuilder syncBuilder(SdkHttpClient httpClient) {
        return (SecretsManagerClientBuilder)super.syncBuilder(httpClient);
    }

    @Override
    @Bean(preDestroy="close")
    @Singleton
    public SecretsManagerClient syncClient(SecretsManagerClientBuilder builder) {
        return (SecretsManagerClient)super.syncClient(builder);
    }

    @Override
    @Singleton
    @Requires(beans={SdkAsyncHttpClient.class})
    public SecretsManagerAsyncClientBuilder asyncBuilder(SdkAsyncHttpClient httpClient) {
        return (SecretsManagerAsyncClientBuilder)super.asyncBuilder(httpClient);
    }

    @Override
    @Bean(preDestroy="close")
    @Singleton
    @Requires(beans={SdkAsyncHttpClient.class})
    public SecretsManagerAsyncClient asyncClient(SecretsManagerAsyncClientBuilder builder) {
        return (SecretsManagerAsyncClient)super.asyncClient(builder);
    }
}

