/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aws.sdk.v2.service.lambda;

import io.micronaut.aws.sdk.v2.service.AWSServiceConfiguration;
import io.micronaut.aws.sdk.v2.service.AwsClientFactory;
import io.micronaut.aws.ua.UserAgentProvider;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.regions.providers.AwsRegionProviderChain;
import software.amazon.awssdk.services.lambda.LambdaAsyncClient;
import software.amazon.awssdk.services.lambda.LambdaAsyncClientBuilder;
import software.amazon.awssdk.services.lambda.LambdaClient;
import software.amazon.awssdk.services.lambda.LambdaClientBuilder;

@Factory
class LambdaClientFactory
extends AwsClientFactory<LambdaClientBuilder, LambdaAsyncClientBuilder, LambdaClient, LambdaAsyncClient> {
    protected LambdaClientFactory(AwsCredentialsProviderChain credentialsProvider, AwsRegionProviderChain regionProvider, @Nullable UserAgentProvider userAgentProvider, @Nullable @Named(value="lambda") AWSServiceConfiguration awsServiceConfiguration) {
        super(credentialsProvider, regionProvider, userAgentProvider, awsServiceConfiguration);
    }

    @Override
    protected LambdaClientBuilder createSyncBuilder() {
        return LambdaClient.builder();
    }

    @Override
    protected LambdaAsyncClientBuilder createAsyncBuilder() {
        return LambdaAsyncClient.builder();
    }

    @Override
    @Singleton
    public LambdaClientBuilder syncBuilder(SdkHttpClient httpClient) {
        return (LambdaClientBuilder)super.syncBuilder(httpClient);
    }

    @Override
    @Bean(preDestroy="close")
    @Singleton
    public LambdaClient syncClient(LambdaClientBuilder builder) {
        return (LambdaClient)super.syncClient(builder);
    }

    @Override
    @Singleton
    @Requires(beans={SdkAsyncHttpClient.class})
    public LambdaAsyncClientBuilder asyncBuilder(SdkAsyncHttpClient httpClient) {
        return (LambdaAsyncClientBuilder)super.asyncBuilder(httpClient);
    }

    @Override
    @Bean(preDestroy="close")
    @Singleton
    @Requires(beans={SdkAsyncHttpClient.class})
    public LambdaAsyncClient asyncClient(LambdaAsyncClientBuilder builder) {
        return (LambdaAsyncClient)super.asyncClient(builder);
    }
}

