/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aws.secretsmanager;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micronaut.aws.secretsmanager.SecretsManagerKeyValueFetcher;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.model.SecretListEntry;

@Requires(beans={SecretsManagerClient.class})
@BootstrapContextCompatible
@Singleton
@Replaces(value=SecretsManagerKeyValueFetcher.class)
public class SecretsManagerGroupNameAwareKeyValueFetcher
extends SecretsManagerKeyValueFetcher {
    private static final Logger LOG = LoggerFactory.getLogger(SecretsManagerGroupNameAwareKeyValueFetcher.class);

    public SecretsManagerGroupNameAwareKeyValueFetcher(SecretsManagerClient secretsClient, ObjectMapper objectMapper) {
        super(secretsClient, objectMapper);
    }

    @Override
    @NonNull
    protected void addSecretDetailsToResults(SecretListEntry secret, Map result) {
        block3: {
            HashMap keyValues = new HashMap();
            Optional<String> secretValueOptional = this.fetchSecretValue(this.secretsClient, secret.name());
            if (secretValueOptional.isPresent()) {
                try {
                    keyValues.putAll((Map)this.objectMapper.readValue(secretValueOptional.get(), Map.class));
                    result.put(secret.name(), keyValues);
                }
                catch (JsonProcessingException e) {
                    if (!LOG.isWarnEnabled()) break block3;
                    LOG.warn("could not read secret ({}) value from JSON to Map", (Object)secret.name());
                }
            }
        }
    }
}

