/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aws.secretsmanager;

import io.micronaut.aws.distributedconfiguration.AwsDistributedConfiguration;
import io.micronaut.aws.distributedconfiguration.AwsDistributedConfigurationClient;
import io.micronaut.aws.distributedconfiguration.KeyValueFetcher;
import io.micronaut.aws.secretsmanager.SecretsManagerConfiguration;
import io.micronaut.aws.secretsmanager.SecretsManagerConfigurationProperties;
import io.micronaut.aws.secretsmanager.SecretsManagerGroupNameAwareKeyValueFetcher;
import io.micronaut.aws.secretsmanager.SecretsManagerKeyValueFetcher;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.runtime.ApplicationConfiguration;
import jakarta.inject.Singleton;
import java.util.Optional;

@Requires(beans={AwsDistributedConfiguration.class, SecretsManagerGroupNameAwareKeyValueFetcher.class})
@Singleton
@BootstrapContextCompatible
public class SecretsManagerConfigurationClient
extends AwsDistributedConfigurationClient {
    private final Optional<SecretsManagerConfiguration> secretsManagerConfiguration;

    public SecretsManagerConfigurationClient(AwsDistributedConfiguration awsDistributedConfiguration, SecretsManagerKeyValueFetcher secretsManagerKeyValueFetcher, @Nullable ApplicationConfiguration applicationConfiguration, SecretsManagerConfiguration secretsManagerConfiguration) {
        super(awsDistributedConfiguration, (KeyValueFetcher)secretsManagerKeyValueFetcher, applicationConfiguration);
        this.secretsManagerConfiguration = Optional.of(secretsManagerConfiguration);
    }

    @NonNull
    protected String adaptPropertyKey(String originalKey, String groupName) {
        SecretsManagerConfiguration secretsConfiguration;
        if (this.secretsManagerConfiguration.isPresent() && CollectionUtils.isNotEmpty((secretsConfiguration = this.secretsManagerConfiguration.get()).getSecrets())) {
            for (SecretsManagerConfigurationProperties.SecretConfiguration secret : secretsConfiguration.getSecrets()) {
                if (!groupName.endsWith(secret.getSecretName())) continue;
                return secret.getPrefix() + "." + originalKey;
            }
        }
        return originalKey;
    }

    @NonNull
    protected String getPropertySourceName() {
        return "awssecretsmanager";
    }

    @NonNull
    public String getDescription() {
        return "AWS Secrets Manager";
    }
}

