/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aws.secretsmanager;

import io.micronaut.aws.secretsmanager.SecretsKeyValueFetcher;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.json.JsonMapper;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.model.DecryptionFailureException;
import software.amazon.awssdk.services.secretsmanager.model.Filter;
import software.amazon.awssdk.services.secretsmanager.model.FilterNameStringType;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;
import software.amazon.awssdk.services.secretsmanager.model.InternalServiceErrorException;
import software.amazon.awssdk.services.secretsmanager.model.InvalidParameterException;
import software.amazon.awssdk.services.secretsmanager.model.InvalidRequestException;
import software.amazon.awssdk.services.secretsmanager.model.ListSecretsRequest;
import software.amazon.awssdk.services.secretsmanager.model.ListSecretsResponse;
import software.amazon.awssdk.services.secretsmanager.model.ResourceNotFoundException;
import software.amazon.awssdk.services.secretsmanager.model.SecretListEntry;
import software.amazon.awssdk.services.secretsmanager.model.SecretsManagerException;

@Requires(beans={SecretsManagerClient.class})
@BootstrapContextCompatible
@Singleton
public class SecretsManagerKeyValueFetcher
implements SecretsKeyValueFetcher {
    private static final Logger LOG = LoggerFactory.getLogger(SecretsManagerKeyValueFetcher.class);
    protected final SecretsManagerClient secretsClient;
    protected final JsonMapper objectMapper;

    public SecretsManagerKeyValueFetcher(SecretsManagerClient secretsClient, JsonMapper objectMapper) {
        this.secretsClient = secretsClient;
        this.objectMapper = objectMapper;
    }

    @NonNull
    public Optional<Map> keyValuesByPrefix(@NonNull String prefix) {
        HashMap result = new HashMap();
        try {
            ListSecretsResponse secretsResponse;
            String nextToken = null;
            do {
                ListSecretsRequest.Builder builder = ListSecretsRequest.builder().nextToken(nextToken).filters(new Filter[]{(Filter)Filter.builder().key(FilterNameStringType.NAME).values(new String[]{prefix}).build()});
                if (nextToken != null) {
                    builder = builder.nextToken(nextToken);
                }
                ListSecretsRequest listSecretsRequest = (ListSecretsRequest)builder.build();
                secretsResponse = this.secretsClient.listSecrets(listSecretsRequest);
                List secrets = secretsResponse.secretList();
                if (LOG.isTraceEnabled()) {
                    if (secrets.isEmpty()) {
                        LOG.trace("zero secrets for prefix: {}", (Object)prefix);
                    } else {
                        LOG.trace("# {} secrets for prefix: {}", (Object)secrets.size(), (Object)prefix);
                    }
                }
                for (SecretListEntry secret : secrets) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Evaluating secret {}", (Object)secret.name());
                    }
                    this.addSecretDetailsToResults(secret, result);
                }
            } while ((nextToken = secretsResponse.nextToken()) != null);
        }
        catch (SecretsManagerException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("SecretsManagerException {}", (Object)e.awsErrorDetails().errorMessage());
            }
            return Optional.empty();
        }
        return result.isEmpty() ? Optional.empty() : Optional.of(result);
    }

    @NonNull
    protected void addSecretDetailsToResults(SecretListEntry secret, Map result) {
        block3: {
            Optional<String> secretValueOptional = this.fetchSecretValue(this.secretsClient, secret.name());
            if (secretValueOptional.isPresent()) {
                try {
                    result.putAll((Map)this.objectMapper.readValue(secretValueOptional.get(), Map.class));
                }
                catch (IOException e) {
                    if (!LOG.isWarnEnabled()) break block3;
                    LOG.warn("could not read secret ({}) value from JSON to Map", (Object)secret.name());
                }
            }
        }
    }

    @NonNull
    protected Optional<String> fetchSecretValue(@NonNull SecretsManagerClient secretsClient, @NonNull String secretName) {
        GetSecretValueRequest getSecretValueRequest = (GetSecretValueRequest)GetSecretValueRequest.builder().secretId(secretName).build();
        return this.fetchSecretValueResponse(secretsClient, getSecretValueRequest).map(this::extractSecretValue);
    }

    @NonNull
    private String extractSecretValue(@NonNull GetSecretValueResponse getSecretValueResponse) {
        if (getSecretValueResponse.secretString() != null) {
            return getSecretValueResponse.secretString();
        }
        return new String(Base64.getDecoder().decode(getSecretValueResponse.secretBinary().asByteBuffer()).array());
    }

    @NonNull
    private Optional<GetSecretValueResponse> fetchSecretValueResponse(@NonNull SecretsManagerClient secretsClient, @NonNull GetSecretValueRequest getSecretValueRequest) {
        block12: {
            try {
                return Optional.of(secretsClient.getSecretValue(getSecretValueRequest));
            }
            catch (DecryptionFailureException e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Secrets Manager can't decrypt the protected secret ({}) text using the provided KMS key.", (Object)getSecretValueRequest.secretId());
                }
            }
            catch (InternalServiceErrorException e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("An error occurred on the server side getting secret ({}) value", (Object)getSecretValueRequest.secretId());
                }
            }
            catch (InvalidParameterException e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("You provided an invalid value for a parameter while getting secret ({}) value", (Object)getSecretValueRequest.secretId());
                }
            }
            catch (InvalidRequestException e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("While getting the secret value, you provided a parameter value that is not valid for the current state of the secret ({})", (Object)getSecretValueRequest.secretId());
                }
            }
            catch (ResourceNotFoundException e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Could not find the resource for secret ({})", (Object)getSecretValueRequest.secretId());
                }
            }
            catch (SecretsManagerException e) {
                if (!LOG.isWarnEnabled()) break block12;
                LOG.warn("SecretsManagerException {}", (Object)e.awsErrorDetails().errorMessage());
            }
        }
        return Optional.empty();
    }
}

