/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.aws.servicediscovery.registration;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.util.StringUtils;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.health.HealthStatus;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

@Internal
public class EC2ServiceInstance
implements ServiceInstance,
ServiceInstance.Builder {
    private String id;
    private URI uri;
    private HealthStatus healthStatus;
    private String instanceId;
    private String group;
    private String zone;
    private String region;
    private ConvertibleValues<String> metadata;

    public EC2ServiceInstance(String id, URI uri) {
        this.id = id;
        String userInfo = uri.getUserInfo();
        if (StringUtils.isNotEmpty((CharSequence)userInfo)) {
            try {
                this.uri = new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
                this.metadata = ConvertibleValues.of(Collections.singletonMap("Authorization-Info", userInfo));
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("ServiceInstance URI is invalid: " + e.getMessage(), e);
            }
        } else {
            this.uri = uri;
        }
    }

    public ConvertibleValues<String> getMetadata() {
        return this.metadata;
    }

    public HealthStatus getHealthStatus() {
        return this.healthStatus;
    }

    public Optional<String> getInstanceId() {
        return Optional.ofNullable(this.instanceId);
    }

    public Optional<String> getZone() {
        return Optional.ofNullable(this.zone);
    }

    public Optional<String> getRegion() {
        return Optional.ofNullable(this.region);
    }

    public Optional<String> getGroup() {
        return Optional.ofNullable(this.group);
    }

    public String getId() {
        return this.id;
    }

    public URI getURI() {
        return this.uri;
    }

    public ServiceInstance.Builder instanceId(String id) {
        this.instanceId = id;
        return this;
    }

    public ServiceInstance.Builder zone(String zone) {
        this.zone = zone;
        return this;
    }

    public ServiceInstance.Builder region(String region) {
        this.region = region;
        return this;
    }

    public ServiceInstance.Builder group(String group) {
        this.group = group;
        return this;
    }

    public ServiceInstance.Builder status(HealthStatus status) {
        this.healthStatus = status;
        return this;
    }

    public ServiceInstance.Builder metadata(ConvertibleValues<String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public ServiceInstance.Builder metadata(Map<String, String> metadata) {
        if (metadata != null) {
            this.metadata = ConvertibleValues.of(metadata);
        }
        return this;
    }

    public ServiceInstance build() {
        return this;
    }
}

