/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.aws.servicediscovery.registration;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.discovery.EmbeddedServerInstance;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.discovery.aws.servicediscovery.AwsServiceDiscoveryRegistrationConfiguration;
import io.micronaut.discovery.aws.servicediscovery.registration.ServiceRegistrationStatusTask;
import io.micronaut.discovery.client.registration.DiscoveryServiceAutoRegistration;
import io.micronaut.discovery.cloud.ComputeInstanceMetadata;
import io.micronaut.discovery.cloud.aws.AmazonComputeInstanceMetadataResolver;
import io.micronaut.discovery.registration.RegistrationConfiguration;
import io.micronaut.health.HealthStatus;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.servicediscovery.ServiceDiscoveryAsyncClient;
import software.amazon.awssdk.services.servicediscovery.ServiceDiscoveryClient;
import software.amazon.awssdk.services.servicediscovery.model.CustomHealthStatus;
import software.amazon.awssdk.services.servicediscovery.model.DeregisterInstanceRequest;
import software.amazon.awssdk.services.servicediscovery.model.RegisterInstanceRequest;
import software.amazon.awssdk.services.servicediscovery.model.Service;
import software.amazon.awssdk.services.servicediscovery.model.UpdateInstanceCustomHealthStatusRequest;

@Internal
@Singleton
@Requirements(value={@Requires(classes={ServiceDiscoveryClient.class}), @Requires(env={"ec2"}), @Requires(beans={AwsServiceDiscoveryRegistrationConfiguration.class}), @Requires(property="aws.service-discovery.registration.enabled", value="true", defaultValue="false"), @Requires(property="micronaut.application.name")})
public class AwsServiceDiscoveryRegistrationClient
extends DiscoveryServiceAutoRegistration {
    public static final String AWS_INSTANCE_PORT = "AWS_INSTANCE_PORT";
    public static final String AWS_INSTANCE_IPV4 = "AWS_INSTANCE_IPV4";
    public static final String AWS_INSTANCE_CNAME = "AWS_INSTANCE_CNAME";
    public static final String AWS_INSTANCE_IPV6 = "AWS_INSTANCE_IPV6";
    public static final String AWS_ALIAS_DNS_NAME = "AWS_ALIAS_DNS_NAME";
    public static final String ENABLED = "aws.service-discovery.registration.enabled";
    private static final Logger LOG = LoggerFactory.getLogger(AwsServiceDiscoveryRegistrationClient.class);
    private final AwsServiceDiscoveryRegistrationConfiguration route53AutoRegistrationConfiguration;
    private final Environment environment;
    private final AmazonComputeInstanceMetadataResolver amazonComputeInstanceMetadataResolver;
    private Service discoveryService;
    private final Executor executorService;
    private final ServiceDiscoveryClient serviceDiscoveryClient;
    private final ServiceDiscoveryAsyncClient serviceDiscoveryAsyncClient;

    protected AwsServiceDiscoveryRegistrationClient(Environment environment, AwsServiceDiscoveryRegistrationConfiguration awsServiceDiscoveryRegistrationConfiguration, AmazonComputeInstanceMetadataResolver amazonComputeInstanceMetadataResolver, @Named(value="io") Executor executorService, ServiceDiscoveryClient serviceDiscoveryClient, ServiceDiscoveryAsyncClient serviceDiscoveryAsyncClient) {
        super((RegistrationConfiguration)awsServiceDiscoveryRegistrationConfiguration);
        this.environment = environment;
        this.route53AutoRegistrationConfiguration = awsServiceDiscoveryRegistrationConfiguration;
        this.serviceDiscoveryClient = serviceDiscoveryClient;
        this.serviceDiscoveryAsyncClient = serviceDiscoveryAsyncClient;
        this.amazonComputeInstanceMetadataResolver = amazonComputeInstanceMetadataResolver;
        this.executorService = executorService;
    }

    protected void pulsate(ServiceInstance instance, HealthStatus status) {
        Optional opt = instance.getInstanceId();
        if (!opt.isPresent()) {
            if (instance.getMetadata().contains("instanceId")) {
                opt = Optional.of(instance.getMetadata().asMap().get("instanceId"));
            } else {
                LOG.error("Cannot determine the instance ID. Are you sure you are running on AWS EC2?");
            }
        }
        opt.ifPresent(instanceId -> {
            if (this.discoveryService != null && this.discoveryService.healthCheckConfig() != null) {
                CustomHealthStatus customHealthStatus = CustomHealthStatus.UNHEALTHY;
                if (status.getOperational().isPresent()) {
                    customHealthStatus = CustomHealthStatus.HEALTHY;
                }
                this.serviceDiscoveryClient.updateInstanceCustomHealthStatus((UpdateInstanceCustomHealthStatusRequest)UpdateInstanceCustomHealthStatusRequest.builder().instanceId(instanceId).serviceId(this.route53AutoRegistrationConfiguration.getAwsServiceId()).status(customHealthStatus).build());
            }
            if (status.getOperational().isPresent() && !((Boolean)status.getOperational().get()).booleanValue()) {
                this.serviceDiscoveryClient.deregisterInstance((DeregisterInstanceRequest)DeregisterInstanceRequest.builder().instanceId(instanceId).serviceId(this.route53AutoRegistrationConfiguration.getAwsServiceId()).build());
                LOG.info("Health status is non operational, instance id {} was de-registered from the discovery service.", instanceId);
            }
        });
    }

    public void deregister(ServiceInstance instance) {
        if (instance.getInstanceId().isPresent()) {
            this.serviceDiscoveryClient.deregisterInstance((DeregisterInstanceRequest)DeregisterInstanceRequest.builder().serviceId(this.route53AutoRegistrationConfiguration.getAwsServiceId()).instanceId((String)instance.getInstanceId().get()).build());
        }
    }

    public void register(ServiceInstance instance) {
        Optional instanceMetadata;
        HashMap<String, String> instanceAttributes = new HashMap<String, String>();
        if (instance.getPort() > 0) {
            instanceAttributes.put(AWS_INSTANCE_PORT, Integer.toString(instance.getPort()));
        }
        if (this.amazonComputeInstanceMetadataResolver != null && (instanceMetadata = this.amazonComputeInstanceMetadataResolver.resolve(this.environment)).isPresent()) {
            ComputeInstanceMetadata computeInstanceMetadata = (ComputeInstanceMetadata)instanceMetadata.get();
            if (computeInstanceMetadata.getPublicIpV4() != null) {
                instanceAttributes.put(AWS_INSTANCE_IPV4, computeInstanceMetadata.getPublicIpV4());
            } else if (computeInstanceMetadata.getPrivateIpV4() != null) {
                instanceAttributes.put(AWS_INSTANCE_IPV4, computeInstanceMetadata.getPrivateIpV4());
            }
            if (!instanceAttributes.containsKey(AWS_INSTANCE_IPV4)) {
                if (computeInstanceMetadata.getPublicIpV4() != null) {
                    instanceAttributes.put(AWS_INSTANCE_IPV6, computeInstanceMetadata.getPublicIpV6());
                } else if (computeInstanceMetadata.getPrivateIpV6() != null) {
                    instanceAttributes.put(AWS_INSTANCE_IPV6, computeInstanceMetadata.getPrivateIpV6());
                }
            }
        }
        ConvertibleValues metadata = instance.getMetadata();
        String instanceId = null;
        if (instance.getInstanceId().isPresent()) {
            instanceId = (String)instance.getInstanceId().get();
        } else if (metadata.contains("instanceId")) {
            instanceId = (String)metadata.asMap().get("instanceId");
        } else {
            LOG.error("Cannot determine the instance ID. Are you sure you are running on AWS EC2?");
        }
        CompletableFuture instanceResult = this.serviceDiscoveryAsyncClient.registerInstance((RegisterInstanceRequest)RegisterInstanceRequest.builder().serviceId(this.route53AutoRegistrationConfiguration.getAwsServiceId()).instanceId(instanceId).creatorRequestId(Long.toString(System.nanoTime())).attributes(instanceAttributes).build());
        LOG.info("Called AWS to register service [{}] with {}", (Object)instance.getId(), (Object)this.route53AutoRegistrationConfiguration.getAwsServiceId());
        instanceResult.whenComplete((registerInstanceResponse, throwable) -> {
            if (throwable != null) {
                LOG.error("Error registering instance with AWS: {}", (Object)throwable.getMessage(), throwable);
                if (this.route53AutoRegistrationConfiguration.isFailFast() && instance instanceof EmbeddedServerInstance) {
                    LOG.error("Error registering instance with AWS and Failfast is set: stopping instance");
                    ((EmbeddedServerInstance)instance).getEmbeddedServer().stop();
                }
            } else if (registerInstanceResponse.operationId() != null) {
                ServiceRegistrationStatusTask serviceRegistrationStatusTask = new ServiceRegistrationStatusTask(this.serviceDiscoveryClient, this.route53AutoRegistrationConfiguration, instance, registerInstanceResponse.operationId());
                this.executorService.execute(serviceRegistrationStatusTask);
                LOG.info("Success calling register service request [{}] with {} is complete.", (Object)instance.getId(), (Object)this.route53AutoRegistrationConfiguration.getAwsServiceId());
            }
        });
    }
}

