/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.aws.servicediscovery.registration;

import io.micronaut.core.annotation.Internal;
import io.micronaut.discovery.EmbeddedServerInstance;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.discovery.aws.servicediscovery.AwsServiceDiscoveryRegistrationConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.servicediscovery.ServiceDiscoveryClient;
import software.amazon.awssdk.services.servicediscovery.model.GetOperationRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetOperationResponse;
import software.amazon.awssdk.services.servicediscovery.model.OperationStatus;

@Internal
class ServiceRegistrationStatusTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceRegistrationStatusTask.class);
    private final String operationId;
    private final AwsServiceDiscoveryRegistrationConfiguration route53AutoRegistrationConfiguration;
    private final ServiceInstance embeddedServerInstance;
    private final ServiceDiscoveryClient serviceDiscoveryClient;
    private boolean registered = false;

    ServiceRegistrationStatusTask(ServiceDiscoveryClient serviceDiscoveryClient, AwsServiceDiscoveryRegistrationConfiguration route53AutoRegistrationConfiguration, ServiceInstance embeddedServerInstance, String operationId) {
        this.serviceDiscoveryClient = serviceDiscoveryClient;
        this.route53AutoRegistrationConfiguration = route53AutoRegistrationConfiguration;
        this.embeddedServerInstance = embeddedServerInstance;
        this.operationId = operationId;
    }

    @Override
    public void run() {
        while (!this.registered) {
            GetOperationResponse result = this.serviceDiscoveryClient.getOperation((GetOperationRequest)GetOperationRequest.builder().operationId(this.operationId).build());
            LOG.info("Service registration for operation {} resulted in {}", (Object)this.operationId, result == null || result.operation() == null ? null : result.operation().status());
            if (result.operation().status() != OperationStatus.FAIL && result.operation().status() != OperationStatus.SUCCESS) continue;
            this.registered = true;
            if (result.operation().status() != OperationStatus.FAIL || !this.route53AutoRegistrationConfiguration.isFailFast() || !(this.embeddedServerInstance instanceof EmbeddedServerInstance)) continue;
            LOG.error("Error registering instance shutting down instance because failfast is set.");
            ((EmbeddedServerInstance)this.embeddedServerInstance).getEmbeddedServer().stop();
        }
        try {
            Thread.currentThread();
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            LOG.error("Registration monitor service has been aborted, unable to verify proper service registration on Route 53.", (Throwable)e);
        }
    }
}

