/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.aws.servicediscovery.client;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.discovery.DiscoveryClient;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.discovery.aws.servicediscovery.AwsServiceDiscoveryClientConfiguration;
import io.micronaut.discovery.aws.servicediscovery.AwsServiceDiscoveryConfiguration;
import io.micronaut.discovery.aws.servicediscovery.registration.EC2ServiceInstance;
import jakarta.inject.Singleton;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Publisher;
import software.amazon.awssdk.services.servicediscovery.ServiceDiscoveryAsyncClient;
import software.amazon.awssdk.services.servicediscovery.model.InstanceSummary;
import software.amazon.awssdk.services.servicediscovery.model.ListInstancesRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListInstancesResponse;
import software.amazon.awssdk.services.servicediscovery.model.ListServicesRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListServicesResponse;
import software.amazon.awssdk.services.servicediscovery.model.ServiceFilter;
import software.amazon.awssdk.services.servicediscovery.model.ServiceFilterName;
import software.amazon.awssdk.services.servicediscovery.model.ServiceSummary;

@Internal
@Singleton
@Requirements(value={@Requires(property="aws.service-discovery.enabled", value="true", defaultValue="false"), @Requires(classes={ServiceDiscoveryAsyncClient.class}), @Requires(env={"ec2"}), @Requires(beans={AwsServiceDiscoveryConfiguration.class})})
public class AwsServiceDiscoveryClient
implements DiscoveryClient {
    private final ServiceDiscoveryAsyncClient serviceDiscoveryAsyncClient;
    private final AwsServiceDiscoveryClientConfiguration awsServiceDiscoveryClientConfiguration;

    public AwsServiceDiscoveryClient(AwsServiceDiscoveryClientConfiguration awsServiceDiscoveryClientConfiguration, ServiceDiscoveryAsyncClient serviceDiscoveryAsyncClient) {
        this.awsServiceDiscoveryClientConfiguration = awsServiceDiscoveryClientConfiguration;
        this.serviceDiscoveryAsyncClient = serviceDiscoveryAsyncClient;
    }

    public String getDescription() {
        return "Aws Service Discovery Client";
    }

    private List<ServiceInstance> convertInstancesResultToServiceInstances(ListInstancesResponse instancesResult) {
        try {
            ArrayList<ServiceInstance> serviceInstances = new ArrayList<ServiceInstance>(instancesResult.instances().size());
            for (InstanceSummary instanceSummary : instancesResult.instances()) {
                String uri = "http://" + (String)instanceSummary.attributes().get("URI");
                serviceInstances.add(new EC2ServiceInstance(instanceSummary.id(), new URI(uri)).metadata(instanceSummary.attributes()).build());
            }
            return serviceInstances;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public Publisher<List<ServiceInstance>> getInstances(String serviceId) {
        if (serviceId == null) {
            serviceId = this.awsServiceDiscoveryClientConfiguration.getAwsServiceId();
        }
        return Publishers.fromCompletableFuture((CompletableFuture)this.serviceDiscoveryAsyncClient.listInstances((ListInstancesRequest)ListInstancesRequest.builder().serviceId(serviceId).build()).thenApply(this::convertInstancesResultToServiceInstances));
    }

    public Publisher<List<String>> getServiceIds() {
        return Publishers.fromCompletableFuture((CompletableFuture)this.serviceDiscoveryAsyncClient.listServices((ListServicesRequest)ListServicesRequest.builder().filters(new ServiceFilter[]{(ServiceFilter)ServiceFilter.builder().name(ServiceFilterName.NAMESPACE_ID).values(new String[]{this.awsServiceDiscoveryClientConfiguration.getNamespaceId()}).build()}).build()).thenApply(this::convertServiceIds));
    }

    public void close() {
        this.serviceDiscoveryAsyncClient.close();
    }

    private List<String> convertServiceIds(ListServicesResponse listServicesResult) {
        List services = listServicesResult.services();
        ArrayList<String> serviceIds = new ArrayList<String>(services.size());
        for (ServiceSummary service : services) {
            serviceIds.add(service.id());
        }
        return serviceIds;
    }
}

