/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws.proxy.test;

import com.amazonaws.serverless.proxy.model.ApiGatewayRequestIdentity;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.model.AwsProxyRequestContext;
import com.amazonaws.serverless.proxy.model.Headers;
import com.amazonaws.serverless.proxy.model.MultiValuedTreeMap;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.function.aws.proxy.test.ServletToAwsProxyRequestAdapter;
import io.micronaut.http.HttpMethod;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.Base64;
import java.util.Enumeration;
import java.util.Map;
import java.util.Optional;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;

@Singleton
public class DefaultServletToAwsProxyRequestAdapter
implements ServletToAwsProxyRequestAdapter {
    @Override
    @NonNull
    public AwsProxyRequest createAwsProxyRequest(@NonNull HttpServletRequest request) {
        AwsProxyRequest awsProxyRequest = new AwsProxyRequest();
        awsProxyRequest.setRequestContext(this.createRequestContext(request));
        awsProxyRequest.setHttpMethod(request.getMethod());
        awsProxyRequest.setPath(request.getRequestURI());
        awsProxyRequest.setMultiValueHeaders(this.createHeaders(request));
        awsProxyRequest.setMultiValueQueryStringParameters(this.createParams(request));
        boolean isBase64Encoded = this.encodeBodyAsBase64();
        awsProxyRequest.setIsBase64Encoded(isBase64Encoded);
        this.createBody(request, isBase64Encoded).ifPresent(arg_0 -> ((AwsProxyRequest)awsProxyRequest).setBody(arg_0));
        return awsProxyRequest;
    }

    @NonNull
    protected AwsProxyRequestContext createRequestContext(@NonNull HttpServletRequest request) {
        AwsProxyRequestContext requestContext = new AwsProxyRequestContext();
        requestContext.setIdentity(new ApiGatewayRequestIdentity());
        requestContext.setHttpMethod(request.getMethod());
        requestContext.setRequestTimeEpoch(Instant.now().toEpochMilli());
        return requestContext;
    }

    @NonNull
    protected Headers createHeaders(@NonNull HttpServletRequest request) {
        Headers requestHeaders = new Headers();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String s = (String)headerNames.nextElement();
            Enumeration headers = request.getHeaders(s);
            while (headers.hasMoreElements()) {
                String v = (String)headers.nextElement();
                requestHeaders.add((Object)s, (Object)v);
            }
        }
        return requestHeaders;
    }

    @NonNull
    protected MultiValuedTreeMap<String, String> createParams(@NonNull HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        MultiValuedTreeMap params = new MultiValuedTreeMap();
        parameterMap.forEach((arg_0, arg_1) -> ((MultiValuedTreeMap)params).addAll(arg_0, arg_1));
        return params;
    }

    protected boolean encodeBodyAsBase64() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    protected Optional<String> createBody(@NonNull HttpServletRequest request, boolean isBase64Encoded) {
        HttpMethod httpMethod = HttpMethod.parse((String)request.getMethod());
        if (!HttpMethod.permitsRequestBody((HttpMethod)httpMethod)) return Optional.empty();
        try (ServletInputStream requestBody = request.getInputStream();){
            byte[] data = IOUtils.toByteArray((InputStream)requestBody);
            if (!isBase64Encoded) return Optional.empty();
            Optional<String> optional = Optional.of(Base64.getEncoder().encodeToString(data));
            return optional;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Optional.empty();
    }
}

