/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws.proxy.test;

import com.amazonaws.serverless.proxy.model.AwsProxyResponse;
import com.amazonaws.serverless.proxy.model.Headers;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.function.aws.proxy.test.ServletToAwsProxyResponseAdapter;
import io.micronaut.http.HttpMethod;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Singleton
public class DefaultServletToAwsProxyResponseAdapter
implements ServletToAwsProxyResponseAdapter {
    @Override
    public void handle(@NonNull HttpServletRequest request, @NonNull AwsProxyResponse awsProxyResponse, @NonNull HttpServletResponse response) throws IOException {
        byte[] bodyAsBytes;
        Headers responseHeaders = awsProxyResponse.getMultiValueHeaders();
        responseHeaders.forEach((key, strings) -> {
            for (String string : strings) {
                response.addHeader(key, string);
            }
        });
        response.setStatus(awsProxyResponse.getStatusCode());
        HttpMethod httpMethod = HttpMethod.parse((String)request.getMethod());
        if (httpMethod != HttpMethod.HEAD && httpMethod != HttpMethod.OPTIONS && (bodyAsBytes = this.parseBodyAsBytes(awsProxyResponse)) != null) {
            response.setContentLength(bodyAsBytes.length);
            if (bodyAsBytes.length > 0) {
                try (ServletOutputStream responseBody = response.getOutputStream();){
                    responseBody.write(bodyAsBytes);
                    responseBody.flush();
                }
            }
        }
    }

    @Nullable
    protected byte[] parseBodyAsBytes(AwsProxyResponse awsProxyResponse) {
        String body = awsProxyResponse.getBody();
        return body == null ? null : (awsProxyResponse.isBase64Encoded() ? Base64.getDecoder().decode(body) : body.getBytes(this.getBodyCharset()));
    }

    protected Charset getBodyCharset() {
        return StandardCharsets.UTF_8;
    }
}

