/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws.proxy.test;

import com.amazonaws.serverless.exceptions.ContainerInitializationException;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.model.AwsProxyResponse;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.context.env.PropertySource;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.socket.SocketUtils;
import io.micronaut.function.aws.proxy.MicronautLambdaHandler;
import io.micronaut.function.aws.proxy.test.ContextProvider;
import io.micronaut.function.aws.proxy.test.ServerPort;
import io.micronaut.function.aws.proxy.test.ServletToAwsProxyRequestAdapter;
import io.micronaut.function.aws.proxy.test.ServletToAwsProxyResponseAdapter;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.exceptions.HttpServerException;
import io.micronaut.http.server.exceptions.ServerStartupException;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.runtime.server.EmbeddedServer;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.net.BindException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;

@Singleton
@Internal
public class AwsApiProxyTestServer
implements EmbeddedServer {
    private final ApplicationContext applicationContext;
    private final ServerPort serverPort;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private Server server;

    public AwsApiProxyTestServer(ApplicationContext applicationContext, HttpServerConfiguration httpServerConfiguration) {
        this.applicationContext = applicationContext;
        this.serverPort = this.createServerPort(httpServerConfiguration);
    }

    private ServerPort createServerPort(HttpServerConfiguration httpServerConfiguration) {
        Optional portOpt = httpServerConfiguration.getPort();
        if (portOpt.isPresent()) {
            Integer port = (Integer)portOpt.get();
            if (port == -1) {
                return new ServerPort(true, SocketUtils.findAvailableTcpPort());
            }
            return new ServerPort(false, port);
        }
        if (this.applicationContext.getEnvironment().getActiveNames().contains("test")) {
            return new ServerPort(true, SocketUtils.findAvailableTcpPort());
        }
        return new ServerPort(false, 8080);
    }

    public EmbeddedServer start() {
        if (this.running.compareAndSet(false, true)) {
            int port = this.serverPort.getPort();
            for (int retryCount = 0; retryCount <= 3; ++retryCount) {
                try {
                    this.server = new Server(port);
                    this.server.setHandler((Handler)new AwsProxyHandler(this.applicationContext));
                    this.server.start();
                    break;
                }
                catch (BindException e) {
                    if (this.serverPort.isRandom()) {
                        port = SocketUtils.findAvailableTcpPort();
                        continue;
                    }
                    throw new ServerStartupException(e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    throw new ServerStartupException(e.getMessage(), (Throwable)e);
                }
            }
            if (this.server == null) {
                throw new HttpServerException("No available ports");
            }
        }
        return this;
    }

    public EmbeddedServer stop() {
        if (this.running.compareAndSet(true, false)) {
            try {
                this.server.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this;
    }

    public int getPort() {
        return this.serverPort.getPort();
    }

    public String getHost() {
        return "localhost";
    }

    public String getScheme() {
        return "http";
    }

    public URL getURL() {
        String spec = this.getScheme() + "://" + this.getHost() + ":" + this.getPort();
        try {
            return new URL(spec);
        }
        catch (MalformedURLException e) {
            throw new HttpServerException("Invalid server URL " + spec);
        }
    }

    public URI getURI() {
        try {
            return this.getURL().toURI();
        }
        catch (URISyntaxException e) {
            throw new HttpServerException("Invalid server URL " + this.getURL());
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public ApplicationConfiguration getApplicationConfiguration() {
        return (ApplicationConfiguration)this.applicationContext.getBean(ApplicationConfiguration.class);
    }

    public boolean isRunning() {
        return this.running.get();
    }

    private static class AwsProxyHandler
    extends AbstractHandler {
        private final MicronautLambdaHandler lambdaHandler;
        private final ServletToAwsProxyRequestAdapter requestAdapter;
        private final ServletToAwsProxyResponseAdapter responseAdapter;
        private final ContextProvider contextProvider;

        public AwsProxyHandler(ApplicationContext proxyTestApplicationContext) throws ContainerInitializationException {
            ApplicationContextBuilder builder = ApplicationContext.builder();
            for (PropertySource propertySource : proxyTestApplicationContext.getEnvironment().getPropertySources()) {
                builder = builder.propertySources(new PropertySource[]{propertySource});
            }
            this.lambdaHandler = new MicronautLambdaHandler(builder);
            ApplicationContext ctx = this.lambdaHandler.getApplicationContext();
            this.requestAdapter = (ServletToAwsProxyRequestAdapter)ctx.getBean(ServletToAwsProxyRequestAdapter.class);
            this.responseAdapter = (ServletToAwsProxyResponseAdapter)ctx.getBean(ServletToAwsProxyResponseAdapter.class);
            this.contextProvider = (ContextProvider)ctx.getBean(ContextProvider.class);
        }

        public void destroy() {
            super.destroy();
            this.lambdaHandler.close();
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
            AwsProxyRequest awsProxyRequest = this.requestAdapter.createAwsProxyRequest(request);
            AwsProxyResponse awsProxyResponse = this.lambdaHandler.handleRequest(awsProxyRequest, this.contextProvider.getContext());
            this.responseAdapter.handle(request, awsProxyResponse, response);
            baseRequest.setHandled(true);
        }
    }
}

