/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws.proxy.test;

import com.amazonaws.services.lambda.runtime.events.APIGatewayV2HTTPResponse;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.function.aws.proxy.MutableMapListOfStringAndMapStringConvertibleMultiValue;
import io.micronaut.function.aws.proxy.test.ServletToAwsProxyResponseAdapter;
import io.micronaut.http.HttpMethod;
import jakarta.inject.Singleton;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;

@Singleton
public class DefaultServletToAwsProxyResponseAdapter
implements ServletToAwsProxyResponseAdapter {
    @Override
    public void handle(@NonNull ConversionService conversionService, @NonNull HttpServletRequest request, @NonNull APIGatewayV2HTTPResponse awsProxyResponse, @NonNull HttpServletResponse response) throws IOException {
        byte[] bodyAsBytes;
        this.populateHeaders(conversionService, awsProxyResponse, response);
        response.setStatus(awsProxyResponse.getStatusCode());
        HttpMethod httpMethod = HttpMethod.parse((String)request.getMethod());
        if (httpMethod != HttpMethod.HEAD && httpMethod != HttpMethod.OPTIONS && (bodyAsBytes = this.parseBodyAsBytes(awsProxyResponse)) != null) {
            response.setContentLength(bodyAsBytes.length);
            if (bodyAsBytes.length > 0) {
                try (ServletOutputStream responseBody = response.getOutputStream();){
                    responseBody.write(bodyAsBytes);
                    responseBody.flush();
                }
            }
        }
    }

    private void populateHeaders(@NonNull ConversionService conversionService, @NonNull APIGatewayV2HTTPResponse apiGatewayV2HTTPResponse, @NonNull HttpServletResponse response) {
        Map singleHeaders = apiGatewayV2HTTPResponse.getHeaders();
        Map multiValueHeaders = apiGatewayV2HTTPResponse.getMultiValueHeaders();
        MutableMapListOfStringAndMapStringConvertibleMultiValue entries = new MutableMapListOfStringAndMapStringConvertibleMultiValue(conversionService, multiValueHeaders, singleHeaders);
        for (String name : entries.names()) {
            response.addHeader(name, String.join((CharSequence)",", entries.getAll((CharSequence)name)));
        }
    }

    @Nullable
    protected byte[] parseBodyAsBytes(APIGatewayV2HTTPResponse awsProxyResponse) {
        String body = awsProxyResponse.getBody();
        if (body == null) {
            return null;
        }
        return awsProxyResponse.getIsBase64Encoded() ? Base64.getMimeDecoder().decode(body) : body.getBytes(this.getBodyCharset());
    }

    protected Charset getBodyCharset() {
        return StandardCharsets.UTF_8;
    }
}

