/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws.proxy.test;

import com.amazonaws.services.lambda.runtime.events.APIGatewayV2HTTPEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayV2HTTPResponse;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import io.micronaut.context.ApplicationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.function.aws.proxy.payload2.APIGatewayV2HTTPEventFunction;
import io.micronaut.function.aws.proxy.test.ContextProvider;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.uri.QueryStringDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
class AwsProxyHttpHandler
implements HttpHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AwsProxyHttpHandler.class);
    APIGatewayV2HTTPEventFunction handler;
    private final ContextProvider contextProvider;

    AwsProxyHttpHandler(APIGatewayV2HTTPEventFunction handler) {
        this.handler = handler;
        ApplicationContext ctx = handler.getApplicationContext();
        this.contextProvider = (ContextProvider)ctx.getBean(ContextProvider.class);
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        APIGatewayV2HTTPEvent awsProxyRequest = this.createAwsProxyRequest(httpExchange);
        APIGatewayV2HTTPResponse apiGatewayV2HTTPResponse = this.handler.handleRequest(awsProxyRequest, this.contextProvider.getContext());
        String payload = apiGatewayV2HTTPResponse.getBody();
        String contentLengthObject = (String)apiGatewayV2HTTPResponse.getHeaders().get("Content-Length");
        int contentLength = StringUtils.isNotEmpty((CharSequence)contentLengthObject) ? Integer.parseInt(contentLengthObject) : 0;
        for (String headerName : apiGatewayV2HTTPResponse.getHeaders().keySet()) {
            String headerValue = (String)apiGatewayV2HTTPResponse.getHeaders().get(headerName);
            List<String> headerValues = List.of(headerValue.split(","));
            httpExchange.getResponseHeaders().put(headerName, StringUtils.isEmpty((CharSequence)headerValue) ? Collections.emptyList() : headerValues);
        }
        httpExchange.sendResponseHeaders(apiGatewayV2HTTPResponse.getStatusCode(), contentLength);
        if (StringUtils.isNotEmpty((CharSequence)payload)) {
            OutputStream output = httpExchange.getResponseBody();
            byte[] payloadBytes = payload.getBytes();
            if (apiGatewayV2HTTPResponse.getIsBase64Encoded()) {
                payloadBytes = Base64.getDecoder().decode(payloadBytes);
            }
            output.write(payloadBytes);
            output.flush();
        }
        httpExchange.close();
    }

    private APIGatewayV2HTTPEvent createAwsProxyRequest(final HttpExchange httpExchange) {
        boolean isBase64Encoded = true;
        return new APIGatewayV2HTTPEvent(){
            private String body;

            public Map<String, String> getHeaders() {
                HashMap<String, String> result = new HashMap<String, String>();
                Set<String> headerNames = httpExchange.getRequestHeaders().keySet();
                for (String headerName : headerNames) {
                    Object values = httpExchange.getRequestHeaders().get(headerName);
                    result.put(headerName, String.join((CharSequence)",", (Iterable<? extends CharSequence>)values));
                }
                return result;
            }

            public List<String> getCookies() {
                return httpExchange.getRequestHeaders().get("Cookie");
            }

            private Optional<String> firstHeaderValue(String headerName) {
                Object headerValues = httpExchange.getRequestHeaders().get(headerName);
                if (CollectionUtils.isEmpty((Collection)headerValues)) {
                    return Optional.empty();
                }
                return Optional.of((String)headerValues.get(0));
            }

            public Map<String, String> getQueryStringParameters() {
                Map parameters = new QueryStringDecoder(httpExchange.getRequestURI()).parameters();
                HashMap<String, String> queryParams = new HashMap<String, String>();
                for (String k : parameters.keySet()) {
                    queryParams.put(k, String.join((CharSequence)",", (Iterable)parameters.get(k)));
                }
                return queryParams;
            }

            public APIGatewayV2HTTPEvent.RequestContext getRequestContext() {
                APIGatewayV2HTTPEvent.RequestContext.Http.HttpBuilder httpBuilder = APIGatewayV2HTTPEvent.RequestContext.Http.builder().withPath(httpExchange.getRequestURI().getPath()).withMethod(httpExchange.getRequestMethod()).withProtocol(httpExchange.getProtocol());
                this.firstHeaderValue("User-Agent").ifPresent(arg_0 -> ((APIGatewayV2HTTPEvent.RequestContext.Http.HttpBuilder)httpBuilder).withUserAgent(arg_0));
                return APIGatewayV2HTTPEvent.RequestContext.builder().withHttp(httpBuilder.build()).build();
            }

            public boolean getIsBase64Encoded() {
                return true;
            }

            public String getBody() {
                HttpMethod httpMethod;
                if (this.body == null && HttpMethod.permitsRequestBody((HttpMethod)(httpMethod = HttpMethod.parse((String)httpExchange.getRequestMethod())))) {
                    try (InputStream requestBody = httpExchange.getRequestBody();){
                        byte[] data = requestBody.readAllBytes();
                        this.body = Base64.getEncoder().encodeToString(data);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return this.body;
            }
        };
    }
}

