/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws.proxy.test;

import com.sun.net.httpserver.HttpHandler;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.context.ApplicationContextProvider;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.env.PropertySource;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.function.aws.proxy.payload2.APIGatewayV2HTTPEventFunction;
import io.micronaut.function.aws.proxy.test.AwsProxyHttpHandler;
import jakarta.inject.Named;
import jakarta.inject.Singleton;

@Internal
@Factory
class EmbeddedServerFactory {
    EmbeddedServerFactory() {
    }

    @Named(value="HttpServer")
    @Singleton
    ApplicationContextProvider httpServerApplicationContextProvider(ApplicationContext applicationContext) {
        ApplicationContextBuilder builder = ApplicationContext.builder();
        for (PropertySource propertySource : applicationContext.getEnvironment().getPropertySources()) {
            builder = builder.propertySources(new PropertySource[]{propertySource});
        }
        return new APIGatewayV2HTTPEventFunction(builder.build());
    }

    @Singleton
    HttpHandler createHandler(@Named(value="HttpServer") ApplicationContextProvider applicationContextProvider) {
        if (applicationContextProvider instanceof APIGatewayV2HTTPEventFunction) {
            APIGatewayV2HTTPEventFunction function = (APIGatewayV2HTTPEventFunction)applicationContextProvider;
            return new AwsProxyHttpHandler(function);
        }
        throw new ConfigurationException("ApplicationContextProvider with name qualifier HttpServer should be of type APIGatewayV2HTTPEventFunction");
    }
}

