/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws.proxy.test;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.MediaType;
import io.micronaut.json.JsonMapper;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class BodyUtils {
    private static final Logger LOG = LoggerFactory.getLogger(BodyUtils.class);

    private BodyUtils() {
    }

    @NonNull
    public static Optional<String> bodyAsString(@NonNull JsonMapper jsonMapper, @NonNull Supplier<MediaType> contentTypeSupplier, @NonNull Supplier<Charset> characterEncodingSupplier, @NonNull Supplier<Object> bodySupplier) {
        boolean mapFromJson;
        Object body = bodySupplier.get();
        MediaType mediaType = contentTypeSupplier.get();
        boolean bl = mapFromJson = mediaType == null || mediaType.equals((Object)MediaType.APPLICATION_JSON_TYPE);
        if (body instanceof CharSequence) {
            return Optional.of(body.toString());
        }
        if (body instanceof byte[]) {
            byte[] bytes = (byte[])body;
            return Optional.of(new String(bytes, characterEncodingSupplier.get()));
        }
        if (mapFromJson) {
            try {
                return Optional.of(jsonMapper.writeValueAsString(body));
            }
            catch (IOException e) {
                LOG.error("IOException writing body to JSON String", (Throwable)e);
                return Optional.empty();
            }
        }
        return Optional.empty();
    }
}

