/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws.proxy.test;

import com.amazonaws.services.lambda.runtime.events.APIGatewayV2HTTPEvent;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.function.aws.proxy.test.ServletToAwsProxyRequestAdapter;
import io.micronaut.http.HttpMethod;
import jakarta.inject.Singleton;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Internal
@Singleton
public class DefaultServletToAwsProxyRequestAdapter
implements ServletToAwsProxyRequestAdapter {
    @Override
    @NonNull
    public APIGatewayV2HTTPEvent createAwsProxyRequest(final @NonNull HttpServletRequest request) {
        boolean isBase64Encoded = true;
        return new APIGatewayV2HTTPEvent(){

            public Map<String, String> getHeaders() {
                HashMap<String, String> result = new HashMap<String, String>();
                Enumeration headerNames = request.getHeaderNames();
                while (headerNames.hasMoreElements()) {
                    String headerName = (String)headerNames.nextElement();
                    Enumeration headerValues = request.getHeaders(headerName);
                    ArrayList<String> values = new ArrayList<String>();
                    while (headerValues.hasMoreElements()) {
                        values.add((String)headerValues.nextElement());
                    }
                    result.put(headerName, String.join((CharSequence)",", values));
                }
                return result;
            }

            public List<String> getCookies() {
                Enumeration headerValues = request.getHeaders("Cookie");
                ArrayList<String> cookies = new ArrayList<String>();
                while (headerValues.hasMoreElements()) {
                    cookies.add((String)headerValues.nextElement());
                }
                return cookies;
            }

            private Optional<String> firstHeaderValue(String headerName) {
                Enumeration headerValues = request.getHeaders(headerName);
                if (headerValues == null) {
                    return Optional.empty();
                }
                if (headerValues.hasMoreElements()) {
                    return Optional.of((String)headerValues.nextElement());
                }
                return Optional.empty();
            }

            public Map<String, String> getQueryStringParameters() {
                Map parameterMap = request.getParameterMap();
                HashMap<String, String> result = new HashMap<String, String>();
                for (String paramterName : parameterMap.keySet()) {
                    result.put(paramterName, String.join((CharSequence)",", (CharSequence[])parameterMap.get(paramterName)));
                }
                return result;
            }

            public APIGatewayV2HTTPEvent.RequestContext getRequestContext() {
                APIGatewayV2HTTPEvent.RequestContext.Http.HttpBuilder httpBuilder = APIGatewayV2HTTPEvent.RequestContext.Http.builder().withPath(request.getRequestURI()).withMethod(request.getMethod()).withProtocol(request.getProtocol());
                this.firstHeaderValue("User-Agent").ifPresent(arg_0 -> ((APIGatewayV2HTTPEvent.RequestContext.Http.HttpBuilder)httpBuilder).withUserAgent(arg_0));
                return APIGatewayV2HTTPEvent.RequestContext.builder().withHttp(httpBuilder.build()).build();
            }

            public boolean getIsBase64Encoded() {
                return true;
            }

            public String getBody() {
                HttpMethod httpMethod = HttpMethod.parse((String)request.getMethod());
                if (HttpMethod.permitsRequestBody((HttpMethod)httpMethod)) {
                    String string;
                    block9: {
                        ServletInputStream requestBody = request.getInputStream();
                        try {
                            byte[] data = requestBody.readAllBytes();
                            string = Base64.getEncoder().encodeToString(data);
                            if (requestBody == null) break block9;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (requestBody != null) {
                                    try {
                                        requestBody.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        requestBody.close();
                    }
                    return string;
                }
                return null;
            }
        };
    }
}

