/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws.proxy.test;

import com.amazonaws.services.lambda.runtime.events.APIGatewayV2HTTPEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayV2HTTPResponse;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.context.env.PropertySource;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.function.aws.proxy.payload2.APIGatewayV2HTTPEventFunction;
import io.micronaut.function.aws.proxy.test.ContextProvider;
import io.micronaut.function.aws.proxy.test.ServerPort;
import io.micronaut.function.aws.proxy.test.ServletToAwsProxyRequestAdapter;
import io.micronaut.function.aws.proxy.test.ServletToAwsProxyResponseAdapter;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.exceptions.HttpServerException;
import io.micronaut.http.server.exceptions.ServerStartupException;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.runtime.server.EmbeddedServer;
import jakarta.inject.Singleton;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Internal
public class AwsApiProxyTestServer
implements EmbeddedServer {
    private final ApplicationContext applicationContext;
    private final ServerPort serverPort;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private Server server;

    public AwsApiProxyTestServer(ApplicationContext applicationContext, HttpServerConfiguration httpServerConfiguration) {
        this.applicationContext = applicationContext;
        this.serverPort = this.createServerPort(httpServerConfiguration);
    }

    private ServerPort createServerPort(HttpServerConfiguration httpServerConfiguration) {
        Optional portOpt = httpServerConfiguration.getPort();
        if (portOpt.isPresent()) {
            Integer port = (Integer)portOpt.get();
            if (port == -1) {
                return new ServerPort(true, 0);
            }
            return new ServerPort(false, port);
        }
        if (this.applicationContext.getEnvironment().getActiveNames().contains("test")) {
            return new ServerPort(true, 0);
        }
        return new ServerPort(false, 8080);
    }

    public EmbeddedServer start() {
        if (this.running.compareAndSet(false, true)) {
            int port = this.serverPort.getPort();
            try {
                this.server = new Server(port);
                this.server.setHandler((Handler)new AwsProxyHandler(this.applicationContext));
                this.server.start();
            }
            catch (Exception e) {
                throw new ServerStartupException(e.getMessage(), (Throwable)e);
            }
        }
        return this;
    }

    public EmbeddedServer stop() {
        if (this.running.compareAndSet(true, false)) {
            try {
                this.server.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this;
    }

    public int getPort() {
        return this.server.getURI().getPort();
    }

    public String getHost() {
        return "localhost";
    }

    public String getScheme() {
        return "http";
    }

    public URL getURL() {
        String spec = this.getScheme() + "://" + this.getHost() + ":" + this.getPort();
        try {
            return new URL(spec);
        }
        catch (MalformedURLException e) {
            throw new HttpServerException("Invalid server URL " + spec);
        }
    }

    public URI getURI() {
        try {
            return this.getURL().toURI();
        }
        catch (URISyntaxException e) {
            throw new HttpServerException("Invalid server URL " + this.getURL());
        }
    }

    public ApplicationContext getApplicationContext() {
        return ((AwsProxyHandler)this.server.getHandler()).getApplicationContext();
    }

    public ApplicationConfiguration getApplicationConfiguration() {
        return (ApplicationConfiguration)this.getApplicationContext().getBean(ApplicationConfiguration.class);
    }

    public boolean isRunning() {
        return this.running.get();
    }

    private static class AwsProxyHandler
    extends AbstractHandler {
        private static final Logger LOG = LoggerFactory.getLogger(AwsProxyHandler.class);
        private final APIGatewayV2HTTPEventFunction lambdaHandler;
        private final ServletToAwsProxyRequestAdapter requestAdapter;
        private final ServletToAwsProxyResponseAdapter responseAdapter;
        private final ConversionService conversionService;
        private final ContextProvider contextProvider;

        public AwsProxyHandler(ApplicationContext proxyTestApplicationContext) {
            ApplicationContextBuilder builder = ApplicationContext.builder();
            for (PropertySource propertySource : proxyTestApplicationContext.getEnvironment().getPropertySources()) {
                builder = builder.propertySources(new PropertySource[]{propertySource});
            }
            this.lambdaHandler = new APIGatewayV2HTTPEventFunction(builder.build());
            ApplicationContext ctx = this.lambdaHandler.getApplicationContext();
            this.contextProvider = (ContextProvider)ctx.getBean(ContextProvider.class);
            this.requestAdapter = (ServletToAwsProxyRequestAdapter)ctx.getBean(ServletToAwsProxyRequestAdapter.class);
            this.responseAdapter = (ServletToAwsProxyResponseAdapter)ctx.getBean(ServletToAwsProxyResponseAdapter.class);
            this.conversionService = (ConversionService)ctx.getBean(ConversionService.class);
        }

        ApplicationContext getApplicationContext() {
            return this.lambdaHandler.getApplicationContext();
        }

        public void destroy() {
            super.destroy();
            this.lambdaHandler.close();
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
            APIGatewayV2HTTPEvent awsProxyRequest = this.requestAdapter.createAwsProxyRequest(request);
            APIGatewayV2HTTPResponse apiGatewayV2HTTPResponse = this.lambdaHandler.handleRequest(awsProxyRequest, this.contextProvider.getContext());
            this.responseAdapter.handle(this.conversionService, request, apiGatewayV2HTTPResponse, response);
            baseRequest.setHandled(true);
        }
    }
}

