/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws.proxy;

import com.amazonaws.serverless.exceptions.InvalidResponseObjectException;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.model.AwsProxyResponse;
import com.amazonaws.serverless.proxy.model.Headers;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.function.aws.proxy.MicronautLambdaContainerContext;
import io.micronaut.function.aws.proxy.MicronautLambdaContainerHandler;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.cookie.Cookie;
import java.io.Closeable;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;

@TypeHint(value={MicronautAwsProxyResponse.class})
public class MicronautAwsProxyResponse<T>
implements MutableHttpResponse<T>,
Closeable {
    private final MutableConvertibleValues<Object> attributes = new MutableConvertibleValuesMap();
    private final CountDownLatch responseEncodeLatch;
    private final AwsProxyRequest request;
    private final MicronautLambdaContainerContext handler;
    private T body;
    private HttpStatus status;
    private AwsProxyResponse response = new AwsProxyResponse();
    private final AwsHeaders awsHeaders = new AwsHeaders();
    private Headers multiValueHeaders = new Headers();
    private Map<String, Cookie> cookies = new ConcurrentHashMap<String, Cookie>(2);

    MicronautAwsProxyResponse(AwsProxyRequest request, CountDownLatch latch, MicronautLambdaContainerContext environment) {
        this.responseEncodeLatch = latch;
        this.request = request;
        this.response.setMultiValueHeaders(this.multiValueHeaders);
        this.handler = environment;
        this.status = HttpStatus.OK;
        this.response.setStatusCode(HttpStatus.OK.getCode());
    }

    @NonNull
    public MutableConvertibleValues<Object> getAttributes() {
        return this.attributes;
    }

    @NonNull
    public Optional<T> getBody() {
        return Optional.ofNullable(this.body);
    }

    public MutableHttpResponse<T> cookie(Cookie cookie) {
        this.cookies.put(cookie.getName(), cookie);
        return this;
    }

    public <B> MutableHttpResponse<B> body(@Nullable B body) {
        this.body = body;
        return this;
    }

    @NonNull
    public MutableHttpHeaders getHeaders() {
        return this.awsHeaders;
    }

    public MutableHttpResponse<T> status(HttpStatus status, CharSequence message) {
        ArgumentUtils.requireNonNull((String)"status", (Object)status);
        this.status = status;
        this.response.setStatusCode(status.getCode());
        return this;
    }

    public HttpStatus getStatus() {
        return this.status;
    }

    Map<String, Cookie> getAllCookies() {
        return this.cookies;
    }

    AwsProxyResponse getAwsResponse() {
        return this.response;
    }

    AwsProxyRequest getAwsProxyRequest() {
        return this.request;
    }

    String encodeBody() throws InvalidResponseObjectException {
        if (this.body instanceof CharSequence) {
            return this.body.toString();
        }
        byte[] encoded = this.encodeInternal((MediaTypeCodec)this.handler.getJsonCodec());
        if (encoded != null) {
            String contentType = this.getContentType().map(MediaType::toString).orElse(null);
            if (!this.isBinary(contentType)) {
                return new String(encoded, this.getCharacterEncoding());
            }
            this.response.setBase64Encoded(true);
            return Base64.getMimeEncoder().encodeToString(encoded);
        }
        return null;
    }

    private byte[] encodeInternal(MediaTypeCodec codec) throws InvalidResponseObjectException {
        byte[] encoded = null;
        try {
            if (this.body != null) {
                if (this.body instanceof ByteBuffer) {
                    encoded = ((ByteBuffer)this.body).toByteArray();
                } else if (this.body instanceof byte[]) {
                    encoded = (byte[])this.body;
                } else {
                    Optional contentType = this.getContentType();
                    if (!contentType.isPresent()) {
                        this.contentType(MediaType.APPLICATION_JSON_TYPE);
                    }
                    encoded = codec.encode(this.body);
                }
            }
        }
        catch (Exception e) {
            throw new InvalidResponseObjectException("Invalid Response: " + e.getMessage(), e);
        }
        return encoded;
    }

    @Override
    public void close() {
        this.responseEncodeLatch.countDown();
    }

    boolean isBinary(String contentType) {
        if (contentType != null) {
            int semidx = contentType.indexOf(59);
            if (semidx >= 0) {
                return MicronautLambdaContainerHandler.getContainerConfig().isBinaryContentType(contentType.substring(0, semidx));
            }
            return MicronautLambdaContainerHandler.getContainerConfig().isBinaryContentType(contentType);
        }
        return false;
    }

    private class AwsHeaders
    implements MutableHttpHeaders {
        private AwsHeaders() {
        }

        public MutableHttpHeaders add(CharSequence header, CharSequence value) {
            ArgumentUtils.requireNonNull((String)"header", (Object)header);
            ArgumentUtils.requireNonNull((String)"value", (Object)value);
            MicronautAwsProxyResponse.this.multiValueHeaders.add((Object)header.toString(), (Object)value.toString());
            return this;
        }

        public MutableHttpHeaders remove(CharSequence header) {
            ArgumentUtils.requireNonNull((String)"header", (Object)header);
            MicronautAwsProxyResponse.this.multiValueHeaders.remove((Object)header.toString());
            return this;
        }

        public List<String> getAll(CharSequence name) {
            if (StringUtils.isNotEmpty((CharSequence)name)) {
                return MicronautAwsProxyResponse.this.multiValueHeaders.get((Object)name.toString());
            }
            return Collections.emptyList();
        }

        @Nullable
        public String get(CharSequence name) {
            if (StringUtils.isNotEmpty((CharSequence)name)) {
                return (String)MicronautAwsProxyResponse.this.multiValueHeaders.getFirst((Object)name.toString());
            }
            return null;
        }

        public Set<String> names() {
            return MicronautAwsProxyResponse.this.multiValueHeaders.keySet();
        }

        public Collection<List<String>> values() {
            return MicronautAwsProxyResponse.this.multiValueHeaders.values();
        }

        public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
            String v = this.get(name);
            if (v != null) {
                return ConversionService.SHARED.convert((Object)v, conversionContext);
            }
            return Optional.empty();
        }
    }
}

