/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws.proxy;

import com.amazonaws.serverless.exceptions.InvalidRequestEventException;
import com.amazonaws.serverless.proxy.RequestReader;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.model.ContainerConfig;
import com.amazonaws.services.lambda.runtime.Context;
import io.micronaut.core.annotation.Internal;
import io.micronaut.function.aws.proxy.MicronautAwsProxyRequest;
import io.micronaut.function.aws.proxy.MicronautLambdaContainerContext;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.web.router.UriRoute;
import io.micronaut.web.router.UriRouteMatch;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.ws.rs.core.SecurityContext;

@Internal
class MicronautRequestReader
extends RequestReader<AwsProxyRequest, MicronautAwsProxyRequest<?>> {
    private final MicronautLambdaContainerContext environment;

    MicronautRequestReader(MicronautLambdaContainerContext environment) {
        this.environment = environment;
    }

    public MicronautAwsProxyRequest<?> readRequest(AwsProxyRequest request, SecurityContext securityContext, Context lambdaContext, ContainerConfig config) throws InvalidRequestEventException {
        try {
            String path = config.isStripBasePath() ? this.stripBasePath(request.getPath(), config) : MicronautRequestReader.getPathNoBase(request);
            MicronautAwsProxyRequest containerRequest = new MicronautAwsProxyRequest(path, request, securityContext, lambdaContext, config);
            List uriRoutes = this.environment.getRouter().findAllClosest(containerRequest);
            if (uriRoutes.isEmpty() && MicronautRequestReader.isPreflightRequest(containerRequest)) {
                List anyUriRoutes = this.environment.getRouter().findAny((CharSequence)containerRequest.getUri().getPath(), containerRequest).collect(Collectors.toList());
                containerRequest.setAttribute((CharSequence)HttpAttributes.AVAILABLE_HTTP_METHODS, anyUriRoutes.stream().map(UriRouteMatch::getHttpMethod).collect(Collectors.toList()));
            } else if (!uriRoutes.isEmpty()) {
                UriRouteMatch finalRoute = (UriRouteMatch)uriRoutes.get(0);
                UriRoute route = finalRoute.getRoute();
                containerRequest.setAttribute((CharSequence)HttpAttributes.ROUTE, route);
                containerRequest.setAttribute((CharSequence)HttpAttributes.ROUTE_MATCH, finalRoute);
                containerRequest.setAttribute((CharSequence)HttpAttributes.ROUTE_INFO, finalRoute);
                containerRequest.setAttribute((CharSequence)HttpAttributes.URI_TEMPLATE, route.getUriMatchTemplate().toString());
            }
            return containerRequest;
        }
        catch (Exception e) {
            throw new InvalidRequestEventException("Invalid Request: " + e.getMessage(), e);
        }
    }

    static boolean isPreflightRequest(HttpRequest<?> request) {
        HttpHeaders headers = request.getHeaders();
        Optional origin = headers.getOrigin();
        return origin.isPresent() && headers.contains("Access-Control-Request-Method") && HttpMethod.OPTIONS == request.getMethod();
    }

    protected Class<? extends AwsProxyRequest> getRequestClass() {
        return AwsProxyRequest.class;
    }

    private static String getPathNoBase(AwsProxyRequest request) {
        if (request.getResource() == null || "".equals(request.getResource())) {
            return request.getPath();
        }
        if (request.getPathParameters() == null || request.getPathParameters().isEmpty()) {
            return request.getResource();
        }
        String path = request.getResource();
        for (Map.Entry variable : request.getPathParameters().entrySet()) {
            path = path.replaceAll("\\{" + Pattern.quote((String)variable.getKey()) + "\\+?}", (String)variable.getValue());
        }
        return path;
    }
}

