/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws.proxy;

import com.amazonaws.serverless.exceptions.InvalidResponseObjectException;
import com.amazonaws.serverless.proxy.ResponseWriter;
import com.amazonaws.serverless.proxy.internal.testutils.Timer;
import com.amazonaws.serverless.proxy.model.AwsProxyResponse;
import com.amazonaws.serverless.proxy.model.RequestSource;
import com.amazonaws.services.lambda.runtime.Context;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.Writable;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.function.aws.proxy.MicronautAwsProxyResponse;
import io.micronaut.function.aws.proxy.MicronautLambdaContainerContext;
import io.micronaut.function.aws.proxy.cookie.ServerCookieEncoder;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.cookie.Cookie;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class MicronautResponseWriter
extends ResponseWriter<MicronautAwsProxyResponse<?>, AwsProxyResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(MicronautResponseWriter.class);
    private static final String TIMER_NAME = "MICRONAUT_RESPONSE_WRITE";
    private final MicronautLambdaContainerContext lambdaContainerContext;

    MicronautResponseWriter(MicronautLambdaContainerContext lambdaContainerContext) {
        this.lambdaContainerContext = lambdaContainerContext;
    }

    public AwsProxyResponse writeResponse(MicronautAwsProxyResponse<?> containerResponse, Context lambdaContext) throws InvalidResponseObjectException {
        AwsProxyResponse awsProxyResponse;
        block11: {
            Object body;
            Timer.start((String)TIMER_NAME);
            awsProxyResponse = containerResponse.getAwsResponse();
            Map<String, Cookie> cookies = containerResponse.getAllCookies();
            if (CollectionUtils.isNotEmpty(cookies)) {
                List<String> values = ServerCookieEncoder.LAX.encode(cookies.values());
                MutableHttpHeaders headers = containerResponse.getHeaders();
                for (String value : values) {
                    headers.add((CharSequence)"Set-Cookie", (CharSequence)value);
                }
            }
            if ((body = containerResponse.body()) instanceof CharSequence) {
                awsProxyResponse.setBody(body.toString());
            } else if (body instanceof Writable) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                Writable writable = (Writable)body;
                try {
                    Charset characterEncoding = containerResponse.getCharacterEncoding();
                    writable.writeTo((OutputStream)outputStream, characterEncoding);
                    if (containerResponse.isBinary(containerResponse.getContentType().map(Object::toString).orElse(null))) {
                        byte[] bytes = outputStream.toByteArray();
                        awsProxyResponse.setBody(Base64.getMimeEncoder().encodeToString(bytes));
                        awsProxyResponse.setBase64Encoded(true);
                        break block11;
                    }
                    String output = new String(outputStream.toByteArray(), characterEncoding);
                    awsProxyResponse.setBody(output);
                }
                catch (IOException e) {
                    LOG.error(e.getMessage());
                }
            } else if (body != null) {
                awsProxyResponse.setBody(containerResponse.encodeBody());
            }
        }
        if (containerResponse.getAwsProxyRequest().getRequestSource() == RequestSource.ALB) {
            HttpStatus status = containerResponse.getStatus();
            awsProxyResponse.setStatusDescription(status + " " + Response.Status.fromStatusCode((int)status.getCode()).getReasonPhrase());
        }
        Timer.stop((String)TIMER_NAME);
        return awsProxyResponse;
    }
}

