/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws.proxy.cookie;

import io.micronaut.core.annotation.Internal;
import io.micronaut.function.aws.proxy.cookie.CookieEncoder;
import io.micronaut.function.aws.proxy.cookie.CookieUtil;
import io.micronaut.function.aws.proxy.cookie.DateFormatter;
import io.micronaut.http.cookie.Cookie;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class ServerCookieEncoder
extends CookieEncoder {
    public static final ServerCookieEncoder STRICT = new ServerCookieEncoder(true);
    public static final ServerCookieEncoder LAX = new ServerCookieEncoder(false);
    private static final Logger LOG = LoggerFactory.getLogger(ServerCookieEncoder.class);

    private ServerCookieEncoder(boolean strict) {
        super(strict);
    }

    private static boolean isWrap(Cookie cookie) {
        CharSequence unwrappedValue = CookieUtil.unwrapValue(cookie.getValue());
        if (unwrappedValue == null) {
            LOG.debug("returning false for wrap cookie because starting quotes are not properly balanced in '{}'", (Object)unwrappedValue);
            return false;
        }
        return unwrappedValue.length() != cookie.getValue().length();
    }

    public String encode(Cookie cookie) {
        String name = Objects.requireNonNull(cookie).getName();
        String value = cookie.getValue() != null ? cookie.getValue() : "";
        this.validateCookie(name, value);
        StringBuffer buf = CookieUtil.stringBuffer();
        if (ServerCookieEncoder.isWrap(cookie)) {
            CookieUtil.addQuoted(buf, name, value);
        } else {
            CookieUtil.add(buf, name, value);
        }
        if (cookie.getMaxAge() != Long.MIN_VALUE) {
            CookieUtil.add(buf, "Max-Age", cookie.getMaxAge());
            Date expires = new Date(cookie.getMaxAge() * 1000L + System.currentTimeMillis());
            buf.append("Expires");
            buf.append('=');
            DateFormatter.append(expires, buf);
            buf.append(';');
            buf.append(' ');
        }
        if (cookie.getPath() != null) {
            CookieUtil.add(buf, "Path", cookie.getPath());
        }
        if (cookie.getDomain() != null) {
            CookieUtil.add(buf, "Domain", cookie.getDomain());
        }
        if (cookie.isSecure()) {
            CookieUtil.add(buf, "Secure");
        }
        if (cookie.isHttpOnly()) {
            CookieUtil.add(buf, "HTTPOnly");
        }
        cookie.getSameSite().map(Enum::name).ifPresent(sameSiteName -> CookieUtil.add(buf, "SameSite", sameSiteName));
        return CookieUtil.stripTrailingSeparator(buf);
    }

    private static List<String> dedup(List<String> encoded, Map<String, Integer> nameToLastIndex) {
        boolean[] isLastInstance = new boolean[encoded.size()];
        for (int idx : nameToLastIndex.values()) {
            isLastInstance[idx] = true;
        }
        ArrayList<String> dedupd = new ArrayList<String>(nameToLastIndex.size());
        int n = encoded.size();
        for (int i = 0; i < n; ++i) {
            if (!isLastInstance[i]) continue;
            dedupd.add(encoded.get(i));
        }
        return dedupd;
    }

    public List<String> encode(Cookie ... cookies) {
        if (Objects.requireNonNull(cookies).length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> encoded = new ArrayList<String>(cookies.length);
        HashMap<String, Integer> nameToIndex = this.strict && cookies.length > 1 ? new HashMap<String, Integer>() : null;
        boolean hasDupdName = false;
        for (int i = 0; i < cookies.length; ++i) {
            Cookie c = cookies[i];
            encoded.add(this.encode(c));
            if (nameToIndex == null) continue;
            hasDupdName |= nameToIndex.put(c.getName(), i) != null;
        }
        return hasDupdName ? ServerCookieEncoder.dedup(encoded, nameToIndex) : encoded;
    }

    public List<String> encode(Collection<? extends Cookie> cookies) {
        if (Objects.requireNonNull(cookies).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> encoded = new ArrayList<String>(cookies.size());
        HashMap<String, Integer> nameToIndex = this.strict && cookies.size() > 1 ? new HashMap<String, Integer>() : null;
        int i = 0;
        boolean hasDupdName = false;
        for (Cookie cookie : cookies) {
            encoded.add(this.encode(cookie));
            if (nameToIndex == null) continue;
            hasDupdName |= nameToIndex.put(cookie.getName(), i++) != null;
        }
        return hasDupdName ? ServerCookieEncoder.dedup(encoded, nameToIndex) : encoded;
    }

    public List<String> encode(Iterable<? extends Cookie> cookies) {
        boolean hasDupdName;
        Iterator<? extends Cookie> cookiesIt = Objects.requireNonNull(cookies).iterator();
        if (!cookiesIt.hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<String> encoded = new ArrayList<String>();
        Cookie firstCookie = cookiesIt.next();
        HashMap<String, Integer> nameToIndex = this.strict && cookiesIt.hasNext() ? new HashMap<String, Integer>() : null;
        int i = 0;
        encoded.add(this.encode(firstCookie));
        boolean bl = hasDupdName = nameToIndex != null && nameToIndex.put(firstCookie.getName(), i++) != null;
        while (cookiesIt.hasNext()) {
            Cookie c = cookiesIt.next();
            encoded.add(this.encode(c));
            if (nameToIndex == null) continue;
            hasDupdName |= nameToIndex.put(c.getName(), i++) != null;
        }
        return hasDupdName ? ServerCookieEncoder.dedup(encoded, nameToIndex) : encoded;
    }
}

