/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws.proxy;

import com.amazonaws.serverless.exceptions.ContainerInitializationException;
import com.amazonaws.serverless.proxy.ExceptionHandler;
import com.amazonaws.serverless.proxy.LogFormatter;
import com.amazonaws.serverless.proxy.RequestReader;
import com.amazonaws.serverless.proxy.ResponseWriter;
import com.amazonaws.serverless.proxy.SecurityContextWriter;
import com.amazonaws.serverless.proxy.internal.SecurityUtils;
import com.amazonaws.serverless.proxy.model.ContainerConfig;
import com.amazonaws.services.lambda.runtime.Context;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import javax.ws.rs.core.SecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLambdaContainerHandler<RequestType, ResponseType, ContainerRequestType, ContainerResponseType> {
    public static final String SERVER_INFO = "aws-serverless-java-container";
    private static ContainerConfig config = ContainerConfig.defaultConfig();
    protected Context lambdaContext;
    private final RequestReader<RequestType, ContainerRequestType> requestReader;
    private final ResponseWriter<ContainerResponseType, ResponseType> responseWriter;
    private final SecurityContextWriter<RequestType> securityContextWriter;
    private final ExceptionHandler<ResponseType> exceptionHandler;
    private final Class<RequestType> requestTypeClass;
    private final Class<ResponseType> responseTypeClass;
    private LogFormatter<ContainerRequestType, ContainerResponseType> logFormatter;
    private final Logger log = LoggerFactory.getLogger(AbstractLambdaContainerHandler.class);

    protected AbstractLambdaContainerHandler(Class<RequestType> requestClass, Class<ResponseType> responseClass, RequestReader<RequestType, ContainerRequestType> requestReader, ResponseWriter<ContainerResponseType, ResponseType> responseWriter, SecurityContextWriter<RequestType> securityContextWriter, ExceptionHandler<ResponseType> exceptionHandler) {
        this.log.info("Starting Lambda Container Handler");
        this.requestTypeClass = requestClass;
        this.responseTypeClass = responseClass;
        this.requestReader = requestReader;
        this.responseWriter = responseWriter;
        this.securityContextWriter = securityContextWriter;
        this.exceptionHandler = exceptionHandler;
        config.addBinaryContentTypes(new String[]{"application/zip"});
    }

    protected abstract ObjectMapper objectMapper();

    protected abstract ObjectWriter writerFor(Class<ResponseType> var1);

    protected abstract ObjectReader readerFor(Class<RequestType> var1);

    protected abstract ContainerResponseType getContainerResponse(ContainerRequestType var1, CountDownLatch var2);

    protected abstract void handleRequest(ContainerRequestType var1, ContainerResponseType var2, Context var3) throws Exception;

    public abstract void initialize() throws ContainerInitializationException;

    public void stripBasePath(String basePath) {
        if (basePath == null || "".equals(basePath)) {
            config.setStripBasePath(false);
            config.setServiceBasePath(null);
        } else {
            config.setStripBasePath(true);
            config.setServiceBasePath(basePath);
        }
    }

    public void setLogFormatter(LogFormatter<ContainerRequestType, ContainerResponseType> formatter) {
        this.logFormatter = formatter;
    }

    public ResponseType proxy(RequestType request, Context context) {
        this.lambdaContext = context;
        try {
            SecurityContext securityContext = this.securityContextWriter.writeSecurityContext(request, context);
            CountDownLatch latch = new CountDownLatch(1);
            Object containerRequest = this.requestReader.readRequest(request, securityContext, context, config);
            ContainerResponseType containerResponse = this.getContainerResponse(containerRequest, latch);
            this.handleRequest(containerRequest, containerResponse, context);
            latch.await();
            if (this.logFormatter != null && this.log.isInfoEnabled()) {
                this.log.info(SecurityUtils.crlf((String)this.logFormatter.format(containerRequest, containerResponse, securityContext)));
            }
            return (ResponseType)this.responseWriter.writeResponse(containerResponse, context);
        }
        catch (Exception e) {
            this.log.error("Error while handling request", (Throwable)e);
            return (ResponseType)this.exceptionHandler.handle((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void proxyStream(InputStream input, OutputStream output, Context context) throws IOException {
        try {
            Object request = this.readerFor(this.requestTypeClass).readValue(input);
            ResponseType resp = this.proxy(request, context);
            this.writerFor(this.responseTypeClass).writeValue(output, resp);
        }
        catch (JsonParseException e) {
            this.log.error("Error while parsing request object stream", (Throwable)e);
            this.objectMapper().writeValue(output, this.exceptionHandler.handle((Throwable)e));
        }
        catch (JsonMappingException e) {
            this.log.error("Error while mapping object to RequestType class", (Throwable)e);
            this.objectMapper().writeValue(output, this.exceptionHandler.handle((Throwable)e));
        }
        finally {
            output.flush();
            output.close();
        }
    }

    public static ContainerConfig getContainerConfig() {
        return config;
    }
}

