/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws.proxy;

import com.amazonaws.serverless.proxy.AwsProxyExceptionHandler;
import com.amazonaws.serverless.proxy.ExceptionHandler;
import com.amazonaws.serverless.proxy.model.AwsProxyResponse;
import com.amazonaws.serverless.proxy.model.ErrorModel;
import com.amazonaws.serverless.proxy.model.Headers;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.micronaut.function.aws.proxy.MicronautLambdaContainerContext;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicronautAwsProxyExceptionHandler
implements ExceptionHandler<AwsProxyResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(AwsProxyExceptionHandler.class);
    private static final String INTERNAL_SERVER_ERROR = "Internal Server Error";
    private static Headers headers = new Headers();
    private final MicronautLambdaContainerContext environment;

    protected MicronautAwsProxyExceptionHandler(MicronautLambdaContainerContext environment) {
        this.environment = environment;
    }

    public AwsProxyResponse handle(Throwable ex) {
        LOG.error("Called exception handler for:", ex);
        ex.printStackTrace();
        return new AwsProxyResponse(500, headers, this.getErrorJson(INTERNAL_SERVER_ERROR));
    }

    public void handle(Throwable ex, OutputStream stream) throws IOException {
        AwsProxyResponse response = this.handle(ex);
        this.environment.getObjectMapper().writeValue(stream, (Object)response);
    }

    protected String getErrorJson(String message) {
        try {
            return this.environment.getObjectMapper().writeValueAsString((Object)new ErrorModel(message));
        }
        catch (JsonProcessingException e) {
            LOG.error("Could not produce error JSON", (Throwable)e);
            return "{ \"message\": \"" + message + "\" }";
        }
    }

    static {
        headers.putSingle((Object)"Content-Type", (Object)"application/json");
    }
}

