/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws.proxy;

import com.amazonaws.serverless.proxy.internal.SecurityUtils;
import com.amazonaws.serverless.proxy.internal.jaxrs.AwsProxySecurityContext;
import com.amazonaws.serverless.proxy.model.ApiGatewayRequestIdentity;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.model.AwsProxyRequestContext;
import com.amazonaws.serverless.proxy.model.ContainerConfig;
import com.amazonaws.serverless.proxy.model.Headers;
import com.amazonaws.serverless.proxy.model.MultiValuedTreeMap;
import com.amazonaws.serverless.proxy.model.SingleValueHeaders;
import com.amazonaws.services.lambda.runtime.Context;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.function.aws.proxy.HttpHeaderUtils;
import io.micronaut.function.aws.proxy.MicronautAwsProxyResponse;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpParameters;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.Cookies;
import io.micronaut.http.simple.SimpleHttpHeaders;
import io.micronaut.http.simple.SimpleHttpParameters;
import io.micronaut.http.simple.cookies.SimpleCookie;
import io.micronaut.http.simple.cookies.SimpleCookies;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.ws.rs.core.SecurityContext;

public class MicronautAwsProxyRequest<T>
implements HttpRequest<T> {
    private static final String HEADER_KEY_VALUE_SEPARATOR = "=";
    private static final String CF_PROTOCOL_HEADER_NAME = "CloudFront-Forwarded-Proto";
    private static final String PROTOCOL_HEADER_NAME = "X-Forwarded-Proto";
    private final AwsProxyRequest awsProxyRequest;
    private final HttpMethod httpMethod;
    private final MutableConvertibleValues<Object> attributes = new MutableConvertibleValuesMap();
    private final HttpHeaders headers;
    private final HttpParameters parameters;
    private final String path;
    private final ContainerConfig config;
    private Cookies cookies;
    private MicronautAwsProxyResponse<?> response;
    private T decodedBody;

    MicronautAwsProxyRequest(String path, AwsProxyRequest awsProxyRequest, SecurityContext securityContext, Context lambdaContext, ContainerConfig config) {
        this.config = config;
        this.awsProxyRequest = awsProxyRequest;
        this.path = path;
        String httpMethod = awsProxyRequest.getHttpMethod();
        this.httpMethod = StringUtils.isNotEmpty((CharSequence)httpMethod) ? HttpMethod.valueOf((String)httpMethod) : HttpMethod.GET;
        this.headers = awsProxyRequest.getMultiValueHeaders() != null || awsProxyRequest.getHeaders() != null ? new AwsHeaders(awsProxyRequest.getMultiValueHeaders(), awsProxyRequest.getHeaders()) : new SimpleHttpHeaders(ConversionService.SHARED);
        MultiValuedTreeMap params = awsProxyRequest.getMultiValueQueryStringParameters();
        this.parameters = params != null ? new AwsParameters() : new SimpleHttpParameters(ConversionService.SHARED);
        AwsProxyRequestContext requestContext = awsProxyRequest.getRequestContext();
        this.setAttribute("com.amazonaws.apigateway.request.context", requestContext);
        this.setAttribute("com.amazonaws.apigateway.stage.variables", awsProxyRequest.getStageVariables());
        this.setAttribute("com.amazonaws.apigateway.request", awsProxyRequest);
        if (requestContext != null) {
            this.setAttribute("com.amazonaws.alb.request.context", requestContext.getElb());
        }
        this.setAttribute("com.amazonaws.lambda.context", lambdaContext);
        this.setAttribute("com.amazonaws.serverless.jaxrs.securityContext", config);
        if (MicronautAwsProxyRequest.isSecurityContextPresent(securityContext)) {
            this.setAttribute("micronaut.AUTHENTICATION", securityContext.getUserPrincipal());
        }
    }

    static boolean isSecurityContextPresent(@Nullable SecurityContext securityContext) {
        AwsProxySecurityContext awsProxySecurityContext;
        if (securityContext == null) {
            return false;
        }
        return !(securityContext instanceof AwsProxySecurityContext) || (awsProxySecurityContext = (AwsProxySecurityContext)securityContext).getEvent() != null && awsProxySecurityContext.getEvent().getRequestContext() != null && awsProxySecurityContext.getEvent().getRequestContext().getIdentity() != null;
    }

    public final AwsProxyRequest getAwsProxyRequest() {
        return this.awsProxyRequest;
    }

    @Internal
    public MicronautAwsProxyResponse<?> getResponse() {
        if (this.response == null) {
            throw new IllegalStateException("Response not set");
        }
        return this.response;
    }

    @Internal
    void setResponse(MicronautAwsProxyResponse<?> response) {
        this.response = response;
    }

    @NonNull
    public Cookies getCookies() {
        if (this.cookies == null) {
            SimpleCookies simpleCookies = new SimpleCookies(ConversionService.SHARED);
            this.getHeaders().getAll((CharSequence)"Cookie").forEach(cookieValue -> {
                List<HeaderValue> parsedHeaders = this.parseHeaderValue((String)cookieValue, ";", ",");
                parsedHeaders.stream().filter(e -> e.getKey() != null).map(e -> new SimpleCookie(SecurityUtils.crlf((String)e.getKey()), SecurityUtils.crlf((String)e.getValue()))).forEach(simpleCookie -> simpleCookies.put((CharSequence)simpleCookie.getName(), (Cookie)simpleCookie));
            });
            this.cookies = simpleCookies;
        }
        return this.cookies;
    }

    @NonNull
    public HttpParameters getParameters() {
        return this.parameters;
    }

    @NonNull
    public HttpMethod getMethod() {
        return this.httpMethod;
    }

    @NonNull
    public URI getUri() {
        String region = System.getenv("AWS_REGION");
        if (region == null) {
            region = "us-east-1";
        }
        Headers multiValueHeaders = this.awsProxyRequest.getMultiValueHeaders();
        SingleValueHeaders singleValueHeaders = this.awsProxyRequest.getHeaders();
        String hostHeader = multiValueHeaders != null ? (String)multiValueHeaders.getFirst((Object)"Host") : null;
        hostHeader = hostHeader == null && singleValueHeaders != null ? (String)singleValueHeaders.get((Object)"Host") : null;
        AwsProxyRequestContext requestContext = this.awsProxyRequest.getRequestContext();
        if (requestContext != null && !this.isValidHost(hostHeader, requestContext.getApiId(), region)) {
            hostHeader = requestContext.getApiId() + ".execute-api." + region + ".amazonaws.com";
        }
        return URI.create(this.getScheme() + "://" + hostHeader + this.path);
    }

    @NonNull
    public InetSocketAddress getRemoteAddress() {
        ApiGatewayRequestIdentity identity;
        AwsProxyRequestContext requestContext = this.awsProxyRequest.getRequestContext();
        if (requestContext != null && (identity = requestContext.getIdentity()) != null) {
            String sourceIp = identity.getSourceIp();
            return new InetSocketAddress(sourceIp, 0);
        }
        return super.getRemoteAddress();
    }

    private boolean isValidHost(String host, String apiId, String region) {
        if (host == null) {
            return false;
        }
        if (host.endsWith(".amazonaws.com")) {
            String defaultHost = apiId + ".execute-api." + region + ".amazonaws.com";
            return host.equals(defaultHost);
        }
        return this.config.getCustomDomainNames().contains(host);
    }

    @NonNull
    public Optional<MediaType> getContentType() {
        Optional specifiedType = super.getContentType();
        if (specifiedType.isPresent()) {
            return specifiedType;
        }
        return Optional.of(MediaType.APPLICATION_JSON_TYPE);
    }

    @NonNull
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @NonNull
    public MutableConvertibleValues<Object> getAttributes() {
        return this.attributes;
    }

    @NonNull
    public Optional<T> getBody() {
        if (this.decodedBody != null) {
            return Optional.of(this.decodedBody);
        }
        String body = this.awsProxyRequest.getBody();
        if (this.awsProxyRequest.isBase64Encoded() && body != null) {
            return Optional.ofNullable(Base64.getMimeDecoder().decode(body));
        }
        return Optional.ofNullable(body);
    }

    @NonNull
    public <T1> Optional<T1> getBody(Argument<T1> type) {
        if (this.decodedBody != null) {
            return ConversionService.SHARED.convert(this.decodedBody, type);
        }
        String body = this.awsProxyRequest.getBody();
        if (body != null) {
            if (this.awsProxyRequest.isBase64Encoded()) {
                byte[] bytes = Base64.getMimeDecoder().decode(body);
                if (type.getType().isInstance(bytes)) {
                    return Optional.of(bytes);
                }
                return ConversionService.SHARED.convert((Object)bytes, type);
            }
            if (type.getType().isInstance(body)) {
                return Optional.of(body);
            }
            byte[] bytes = body.getBytes(this.getCharacterEncoding());
            return ConversionService.SHARED.convert((Object)bytes, type);
        }
        return Optional.empty();
    }

    protected List<HeaderValue> parseHeaderValue(String headerValue, String valueSeparator, String qualifierSeparator) {
        ArrayList<HeaderValue> values = new ArrayList<HeaderValue>();
        if (headerValue == null) {
            return values;
        }
        String[] stringArray = headerValue.split(valueSeparator);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String v;
            String curValue = v = stringArray[i];
            float curPreference = 1.0f;
            HeaderValue newValue = new HeaderValue();
            newValue.setRawValue(v);
            for (String q : curValue.split(qualifierSeparator)) {
                String[] kv = q.split(HEADER_KEY_VALUE_SEPARATOR, 2);
                String key = null;
                String val = null;
                if (kv.length == 1) {
                    val = q.trim();
                }
                if (kv.length == 2) {
                    if (kv[1].length() == 0) {
                        val = q.trim();
                    }
                    if (HEADER_KEY_VALUE_SEPARATOR.equals(kv[1].trim())) {
                        val = q.trim();
                    } else {
                        key = kv[0].trim();
                        String string = val = "".equals(kv[1].trim()) ? null : kv[1].trim();
                    }
                }
                if (newValue.getValue() == null) {
                    newValue.setKey(key);
                    newValue.setValue(val);
                    continue;
                }
                if ("q".equals(key)) {
                    curPreference = Float.parseFloat(val);
                    continue;
                }
                newValue.addAttribute(key, val);
            }
            newValue.setPriority(curPreference);
            values.add(newValue);
        }
        values.sort((first, second) -> {
            if (first.getPriority() - second.getPriority() < 0.001f) {
                return 0;
            }
            if (first.getPriority() < second.getPriority()) {
                return 1;
            }
            return -1;
        });
        return values;
    }

    @Internal
    void setDecodedBody(T decodedBody) {
        this.decodedBody = decodedBody;
    }

    public boolean isBodyDecoded() {
        return this.decodedBody != null;
    }

    private String getScheme() {
        if (this.awsProxyRequest.getMultiValueHeaders() == null) {
            return "https";
        }
        String cfScheme = (String)this.awsProxyRequest.getMultiValueHeaders().getFirst((Object)CF_PROTOCOL_HEADER_NAME);
        if (cfScheme != null && SecurityUtils.isValidScheme((String)cfScheme)) {
            return cfScheme;
        }
        String gwScheme = (String)this.awsProxyRequest.getMultiValueHeaders().getFirst((Object)PROTOCOL_HEADER_NAME);
        if (gwScheme != null && SecurityUtils.isValidScheme((String)gwScheme)) {
            return gwScheme;
        }
        return "https";
    }

    private static class HeaderValue {
        private String key;
        private String value;
        private String rawValue;
        private float priority;
        private Map<String, String> attributes = new HashMap<String, String>();

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getRawValue() {
            return this.rawValue;
        }

        public void setRawValue(String rawValue) {
            this.rawValue = rawValue;
        }

        public float getPriority() {
            return this.priority;
        }

        public void setPriority(float priority) {
            this.priority = priority;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, String> attributes) {
            this.attributes = attributes;
        }

        public void addAttribute(String key, String value) {
            this.attributes.put(key, value);
        }

        public String getAttribute(String key) {
            return this.attributes.get(key);
        }
    }

    private static class AwsHeaders
    implements HttpHeaders {
        private final Map<String, List<String>> headers;

        public AwsHeaders(@Nullable Headers multivalueHeaders, @Nullable SingleValueHeaders singleValueHeaders) {
            if (multivalueHeaders == null && singleValueHeaders == null) {
                this.headers = Collections.emptyMap();
            } else {
                String headerName;
                this.headers = new HashMap<String, List<String>>();
                if (multivalueHeaders != null) {
                    for (String name : multivalueHeaders.keySet()) {
                        headerName = HttpHeaderUtils.normalizeHttpHeaderCase(name);
                        this.headers.computeIfAbsent(headerName, s -> new ArrayList());
                        this.headers.get(headerName).addAll(multivalueHeaders.get((Object)headerName));
                    }
                }
                if (CollectionUtils.isNotEmpty((Map)singleValueHeaders)) {
                    for (String name : singleValueHeaders.keySet()) {
                        headerName = HttpHeaderUtils.normalizeHttpHeaderCase(name);
                        String value = (String)singleValueHeaders.get((Object)headerName);
                        if (this.headers.containsKey(headerName) && this.headers.get(headerName).contains(value)) continue;
                        this.headers.computeIfAbsent(headerName, s -> new ArrayList());
                        this.headers.get(headerName).add(value);
                    }
                }
            }
        }

        public List<String> getAll(CharSequence name) {
            Optional<String> headerName = this.findKey(name.toString());
            if (!headerName.isPresent()) {
                return Collections.emptyList();
            }
            List<String> values = this.headers.get(headerName.get());
            if (values == null) {
                return Collections.emptyList();
            }
            return values;
        }

        @Nullable
        public String get(CharSequence name) {
            List<String> values = this.getAll(name);
            if (CollectionUtils.isEmpty(values)) {
                return null;
            }
            return values.get(0);
        }

        public Set<String> names() {
            return this.headers.keySet();
        }

        public Collection<List<String>> values() {
            return this.headers.values();
        }

        public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
            String v = this.get(name);
            if (v != null) {
                return ConversionService.SHARED.convert((Object)v, conversionContext);
            }
            return Optional.empty();
        }

        @NonNull
        private Optional<String> findKey(@NonNull String name) {
            for (String headerName : this.headers.keySet()) {
                if (!headerName.equalsIgnoreCase(name)) continue;
                return Optional.of(headerName);
            }
            return Optional.empty();
        }
    }

    private class AwsParameters
    implements HttpParameters {
        private MultiValuedTreeMap<String, String> params;

        private AwsParameters() {
            this.params = MicronautAwsProxyRequest.this.awsProxyRequest.getMultiValueQueryStringParameters();
        }

        public List<String> getAll(CharSequence name) {
            List strings;
            if (StringUtils.isNotEmpty((CharSequence)name) && CollectionUtils.isNotEmpty((Collection)(strings = this.params.get((Object)name.toString())))) {
                return strings;
            }
            return Collections.emptyList();
        }

        @Nullable
        public String get(CharSequence name) {
            if (StringUtils.isNotEmpty((CharSequence)name)) {
                return (String)this.params.getFirst((Object)name.toString());
            }
            return null;
        }

        public Set<String> names() {
            return this.params.keySet();
        }

        public Collection<List<String>> values() {
            return this.params.values();
        }

        public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
            String v = this.get(name);
            if (v != null) {
                return ConversionService.SHARED.convert((Object)v, conversionContext);
            }
            return Optional.empty();
        }
    }
}

