/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws.proxy;

import com.amazonaws.serverless.exceptions.ContainerInitializationException;
import com.amazonaws.serverless.proxy.AwsProxySecurityContextWriter;
import com.amazonaws.serverless.proxy.internal.jaxrs.AwsProxySecurityContext;
import com.amazonaws.serverless.proxy.internal.testutils.Timer;
import com.amazonaws.serverless.proxy.model.AlbContext;
import com.amazonaws.serverless.proxy.model.ApiGatewayAuthorizerContext;
import com.amazonaws.serverless.proxy.model.ApiGatewayRequestIdentity;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.model.AwsProxyRequestContext;
import com.amazonaws.serverless.proxy.model.AwsProxyResponse;
import com.amazonaws.serverless.proxy.model.CognitoAuthorizerClaims;
import com.amazonaws.serverless.proxy.model.ContainerConfig;
import com.amazonaws.serverless.proxy.model.ErrorModel;
import com.amazonaws.serverless.proxy.model.Headers;
import com.amazonaws.serverless.proxy.model.MultiValuedTreeMap;
import com.amazonaws.serverless.proxy.model.SingleValueHeaders;
import com.amazonaws.services.lambda.runtime.Context;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.context.ApplicationContextProvider;
import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.async.subscriber.CompletionAwareSubscriber;
import io.micronaut.core.bind.BeanPropertyBinder;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.convert.value.ConvertibleValuesMap;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.TypeVariableResolver;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.function.aws.HandlerUtils;
import io.micronaut.function.aws.LambdaApplicationContextBuilder;
import io.micronaut.function.aws.proxy.AbstractLambdaContainerHandler;
import io.micronaut.function.aws.proxy.MicronautAwsProxyExceptionHandler;
import io.micronaut.function.aws.proxy.MicronautAwsProxyRequest;
import io.micronaut.function.aws.proxy.MicronautAwsProxyResponse;
import io.micronaut.function.aws.proxy.MicronautLambdaContainerContext;
import io.micronaut.function.aws.proxy.MicronautRequestReader;
import io.micronaut.function.aws.proxy.MicronautResponseWriter;
import io.micronaut.function.aws.proxy.QueryStringDecoder;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.annotation.Status;
import io.micronaut.http.bind.RequestBinderRegistry;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.RouteExecutor;
import io.micronaut.http.server.binding.RequestArgumentSatisfier;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.jackson.codec.JsonMediaTypeCodec;
import io.micronaut.scheduling.executor.ExecutorSelector;
import io.micronaut.web.router.MethodBasedRouteMatch;
import io.micronaut.web.router.RouteInfo;
import io.micronaut.web.router.RouteMatch;
import io.micronaut.web.router.Router;
import io.micronaut.web.router.UriRouteMatch;
import io.micronaut.web.router.resource.StaticResourceResolver;
import java.io.Closeable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@TypeHint(accessType={TypeHint.AccessType.ALL_DECLARED_CONSTRUCTORS, TypeHint.AccessType.ALL_PUBLIC}, value={AlbContext.class, ApiGatewayAuthorizerContext.class, ApiGatewayRequestIdentity.class, AwsProxyRequest.class, AwsProxyRequestContext.class, AwsProxyResponse.class, CognitoAuthorizerClaims.class, ContainerConfig.class, ErrorModel.class, SingleValueHeaders.class, Headers.class, TreeMap.class, MultiValuedTreeMap.class, AwsProxySecurityContext.class})
public final class MicronautLambdaContainerHandler
extends AbstractLambdaContainerHandler<AwsProxyRequest, AwsProxyResponse, MicronautAwsProxyRequest<?>, MicronautAwsProxyResponse<?>>
implements ApplicationContextProvider,
Closeable,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(MicronautLambdaContainerHandler.class);
    private static final String TIMER_INIT = "MICRONAUT_COLD_START";
    private static final String TIMER_REQUEST = "MICRONAUT_HANDLE_REQUEST";
    private final ApplicationContextBuilder applicationContextBuilder;
    private final LambdaContainerState lambdaContainerEnvironment;
    private final BeanPropertyBinder beanPropertyBinder;
    private ApplicationContext applicationContext;
    private RequestArgumentSatisfier requestArgumentSatisfier;
    private StaticResourceResolver resourceResolver;
    private Router router;
    private ErrorResponseProcessor errorResponseProcessor;
    private RouteExecutor routeExecutor;
    private final Map<MediaType, BiFunction<Argument<?>, String, Optional<Object>>> mediaTypeBodyDecoder = new HashMap();

    public MicronautLambdaContainerHandler(ApplicationContextBuilder applicationContextBuilder) throws ContainerInitializationException {
        this(new LambdaContainerState(), applicationContextBuilder, null);
    }

    public MicronautLambdaContainerHandler() throws ContainerInitializationException {
        this(new LambdaContainerState(), ApplicationContext.builder(), null);
    }

    public MicronautLambdaContainerHandler(ApplicationContext applicationContext) throws ContainerInitializationException {
        this(new LambdaContainerState(), ApplicationContext.builder(), applicationContext);
    }

    private MicronautLambdaContainerHandler(LambdaContainerState lambdaContainerEnvironment, ApplicationContextBuilder applicationContextBuilder, ApplicationContext applicationContext) throws ContainerInitializationException {
        super(AwsProxyRequest.class, AwsProxyResponse.class, new MicronautRequestReader(lambdaContainerEnvironment), new MicronautResponseWriter(lambdaContainerEnvironment), new AwsProxySecurityContextWriter(), new MicronautAwsProxyExceptionHandler(lambdaContainerEnvironment));
        ArgumentUtils.requireNonNull((String)"applicationContextBuilder", (Object)applicationContextBuilder);
        this.lambdaContainerEnvironment = lambdaContainerEnvironment;
        this.applicationContextBuilder = applicationContextBuilder;
        if (applicationContext == null) {
            this.initialize();
        } else {
            this.applicationContext = applicationContext;
            this.initContainerState();
        }
        this.beanPropertyBinder = (BeanPropertyBinder)this.applicationContext.getBean(BeanPropertyBinder.class);
        this.populateMediaTypeBodyDecoders();
    }

    private MicronautLambdaContainerHandler(LambdaContainerState lambdaContainerEnvironment) throws ContainerInitializationException {
        this(lambdaContainerEnvironment, ApplicationContext.builder(), null);
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    protected ObjectMapper objectMapper() {
        return this.lambdaContainerEnvironment.getObjectMapper();
    }

    @Override
    protected ObjectWriter writerFor(Class<AwsProxyResponse> responseClass) {
        return this.objectMapper().writerFor(responseClass);
    }

    @Override
    protected ObjectReader readerFor(Class<AwsProxyRequest> requestClass) {
        return this.objectMapper().readerFor(requestClass);
    }

    @Override
    protected MicronautAwsProxyResponse<?> getContainerResponse(MicronautAwsProxyRequest<?> request, CountDownLatch latch) {
        MicronautAwsProxyResponse response = new MicronautAwsProxyResponse(request.getAwsProxyRequest(), latch, this.lambdaContainerEnvironment);
        Optional routeMatchAttr = request.getAttribute((CharSequence)HttpAttributes.ROUTE_MATCH);
        routeMatchAttr.ifPresent(o -> response.setAttribute((CharSequence)HttpAttributes.ROUTE_MATCH, o));
        request.setResponse(response);
        return request.getResponse();
    }

    @Override
    public void initialize() throws ContainerInitializationException {
        Timer.start((String)TIMER_INIT);
        try {
            LambdaApplicationContextBuilder.setLambdaConfiguration((ApplicationContextBuilder)this.applicationContextBuilder);
            this.applicationContext = this.applicationContextBuilder.build().start();
            this.initContainerState();
        }
        catch (Exception e) {
            throw new ContainerInitializationException("Error starting Micronaut container: " + e.getMessage(), e);
        }
        Timer.stop((String)TIMER_INIT);
    }

    protected void initContainerState() {
        this.lambdaContainerEnvironment.setApplicationContext(this.applicationContext);
        this.lambdaContainerEnvironment.setJsonCodec((JsonMediaTypeCodec)this.applicationContext.getBean(JsonMediaTypeCodec.class));
        this.lambdaContainerEnvironment.setRouter((Router)this.applicationContext.getBean(Router.class));
        Optional objectMapper = this.applicationContext.findBean(ObjectMapper.class, Qualifiers.byName((String)"aws"));
        if (objectMapper.isPresent()) {
            this.lambdaContainerEnvironment.setObjectMapper((ObjectMapper)objectMapper.get());
        } else {
            this.lambdaContainerEnvironment.setObjectMapper((ObjectMapper)this.applicationContext.getBean(ObjectMapper.class));
        }
        this.requestArgumentSatisfier = new RequestArgumentSatisfier((RequestBinderRegistry)this.applicationContext.getBean(RequestBinderRegistry.class));
        this.resourceResolver = (StaticResourceResolver)this.applicationContext.getBean(StaticResourceResolver.class);
        this.addConverters();
        this.router = this.lambdaContainerEnvironment.getRouter();
        this.errorResponseProcessor = (ErrorResponseProcessor)this.applicationContext.getBean(ErrorResponseProcessor.class);
        HttpServerConfiguration serverConfiguration = (HttpServerConfiguration)this.applicationContext.getBean(HttpServerConfiguration.class);
        ExecutorSelector executorSelector = (ExecutorSelector)this.applicationContext.getBean(ExecutorSelector.class);
        this.routeExecutor = new RouteExecutor(this.router, (BeanContext)this.applicationContext, this.requestArgumentSatisfier, serverConfiguration, this.errorResponseProcessor, executorSelector);
    }

    protected void addConverters() {
        this.addByteArrayToStringConverter();
    }

    protected void addByteArrayToStringConverter() {
        this.applicationContext.getEnvironment().addConverter(byte[].class, String.class, bytes -> new String((byte[])bytes, StandardCharsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleRequest(MicronautAwsProxyRequest<?> containerRequest, MicronautAwsProxyResponse<?> containerResponse, Context lambdaContext) {
        Timer.start((String)TIMER_REQUEST);
        HandlerUtils.configureWithContext((ApplicationContextProvider)this, (Context)lambdaContext);
        try {
            ServerRequestContext.with(containerRequest, () -> {
                Optional routeMatch = containerRequest.getAttribute((CharSequence)HttpAttributes.ROUTE_MATCH, UriRouteMatch.class);
                if (!routeMatch.isPresent()) {
                    this.handlePossibleErrorStatus(containerRequest, containerResponse);
                    return;
                }
                this.handleRouteMatch((RouteMatch)routeMatch.get(), containerRequest, containerResponse);
            });
        }
        finally {
            Timer.stop((String)TIMER_REQUEST);
        }
    }

    private void handleRouteMatch(RouteMatch<?> originalRoute, final MicronautAwsProxyRequest<?> request, final MicronautAwsProxyResponse<?> response) {
        Flux routeResponse;
        AnnotationMetadata annotationMetadata = originalRoute.getAnnotationMetadata();
        annotationMetadata.stringValue(Produces.class).map(MediaType::new).ifPresent(arg_0 -> response.contentType(arg_0));
        try {
            this.decodeRequestBody(request, originalRoute).ifPresent(request::setDecodedBody);
            RouteMatch route = this.requestArgumentSatisfier.fulfillArgumentRequirements(originalRoute, request, false);
            Flux routeMatchPublisher = Flux.just((Object)route);
            routeResponse = this.routeExecutor.executeRoute(request, true, routeMatchPublisher).mapNotNull(r -> r.getAttribute((CharSequence)HttpAttributes.ROUTE_INFO, RouteInfo.class).map(routeInfo -> (MutableHttpResponse)this.convertResponseBody(response, (RouteInfo<?>)routeInfo, r.body()).block()).orElseGet(() -> response));
        }
        catch (Exception e) {
            routeResponse = Flux.from((Publisher)this.routeExecutor.filterPublisher(new AtomicReference(request), (Publisher)this.routeExecutor.onError((Throwable)e, request)));
        }
        routeResponse.contextWrite(ctx -> ctx.put((Object)"micronaut.http.server.request", (Object)request)).subscribe((Subscriber)new CompletionAwareSubscriber<HttpResponse<?>>(){

            protected void doOnSubscribe(Subscription subscription) {
                subscription.request(1L);
            }

            protected void doOnNext(HttpResponse<?> message) {
                MicronautLambdaContainerHandler.this.toAwsProxyResponse(response, message);
                this.subscription.request(1L);
            }

            protected void doOnError(Throwable throwable) {
                try {
                    MutableHttpResponse defaultErrorResponse = MicronautLambdaContainerHandler.this.routeExecutor.createDefaultErrorResponse((HttpRequest)request, throwable);
                    MicronautLambdaContainerHandler.this.toAwsProxyResponse(response, (HttpResponse)defaultErrorResponse);
                }
                finally {
                    response.close();
                }
            }

            protected void doOnComplete() {
                response.close();
            }
        });
    }

    private MicronautAwsProxyResponse<?> toAwsProxyResponse(MicronautAwsProxyResponse<?> response, HttpResponse<?> message) {
        if (response != message) {
            response.status(message.status(), message.status().getReason());
            response.body(message.body());
            message.getHeaders().forEach((name, value) -> {
                for (String val : value) {
                    response.header((CharSequence)name, val);
                }
            });
            response.getAttributes().putAll((ConvertibleValues)message.getAttributes());
        }
        return response;
    }

    private void populateMediaTypeBodyDecoders() {
        this.mediaTypeBodyDecoder.put(MediaType.APPLICATION_JSON_TYPE, this::getJsonDecodedBody);
        this.mediaTypeBodyDecoder.put(MediaType.APPLICATION_FORM_URLENCODED_TYPE, this::getFormUrlEncodedDecodedBody);
    }

    @NonNull
    private static Optional<String> parseUndecodedBody(@NonNull MicronautAwsProxyRequest<?> containerRequest, @NonNull RouteMatch<?> finalRoute, @NonNull MediaType mediaType) {
        if (containerRequest.isBodyDecoded()) {
            return Optional.empty();
        }
        if (!HttpMethod.permitsRequestBody((HttpMethod)containerRequest.getMethod())) {
            return Optional.empty();
        }
        MediaType requestContentType = containerRequest.getContentType().orElse(null);
        if (requestContentType == null) {
            return Optional.empty();
        }
        if (!mediaType.getExtension().equals(requestContentType.getExtension())) {
            return Optional.empty();
        }
        MediaType[] expectedContentType = finalRoute.getAnnotationMetadata().getValue(Consumes.class, MediaType[].class).orElse(null);
        return expectedContentType == null || Arrays.stream(expectedContentType).anyMatch(ct -> mediaType.getExtension().equals(ct.getExtension())) ? containerRequest.getBody(String.class) : Optional.empty();
    }

    @NonNull
    private Optional<Object> decodeRequestBody(@NonNull MicronautAwsProxyRequest<?> containerRequest, @NonNull RouteMatch<?> finalRoute) {
        return this.mediaTypeBodyDecoder.entrySet().stream().map(e -> MicronautLambdaContainerHandler.decodeRequestBody(containerRequest, finalRoute, e)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    private static Optional<Object> decodeRequestBody(@NonNull MicronautAwsProxyRequest<?> containerRequest, @NonNull RouteMatch<?> finalRoute, @NonNull Map.Entry<MediaType, BiFunction<Argument<?>, String, Optional<Object>>> entry) {
        return MicronautLambdaContainerHandler.parseUndecodedBody(containerRequest, finalRoute, entry.getKey()).flatMap(body -> MicronautLambdaContainerHandler.decodeRequestBody(body, (BiFunction)entry.getValue(), finalRoute));
    }

    @NonNull
    private static Optional<Object> decodeRequestBody(@NonNull String body, @NonNull BiFunction<Argument<?>, String, Optional<Object>> function, @NonNull RouteMatch<?> finalRoute) {
        if (StringUtils.isNotEmpty((CharSequence)body)) {
            Argument<?> bodyArgument = MicronautLambdaContainerHandler.parseBodyArgument(finalRoute);
            return function.apply(bodyArgument, body);
        }
        return Optional.empty();
    }

    @Nullable
    private static Argument<?> parseBodyArgument(@NonNull RouteMatch<?> finalRoute) {
        Class rawType;
        Argument bodyArgument = finalRoute.getBodyArgument().orElse(null);
        if (bodyArgument == null && finalRoute instanceof MethodBasedRouteMatch) {
            bodyArgument = Arrays.stream(((MethodBasedRouteMatch)finalRoute).getArguments()).filter(arg -> HttpRequest.class.isAssignableFrom(arg.getType())).findFirst().flatMap(TypeVariableResolver::getFirstTypeVariable).orElse(null);
        }
        if (bodyArgument != null && (Publishers.isConvertibleToPublisher((Class)(rawType = bodyArgument.getType())) || HttpRequest.class.isAssignableFrom(rawType))) {
            bodyArgument = bodyArgument.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
        }
        return bodyArgument;
    }

    @NonNull
    private Optional<Object> getFormUrlEncodedDecodedBody(@Nullable Argument<?> bodyArgument, @NonNull String body) {
        if (bodyArgument == null) {
            JsonNode encodedValues = this.lambdaContainerEnvironment.getObjectMapper().valueToTree(MicronautLambdaContainerHandler.formUrlEncodedBodyToConvertibleValues(body));
            return Optional.ofNullable(encodedValues);
        }
        if (MicronautLambdaContainerHandler.nestedBody(bodyArgument)) {
            return Optional.ofNullable(MicronautLambdaContainerHandler.formUrlEncodedBodyToConvertibleValues(body));
        }
        return this.bindFormUrlEncoded(bodyArgument, body);
    }

    @NonNull
    private Optional<Object> getJsonDecodedBody(@Nullable Argument<?> bodyArgument, @NonNull String body) {
        if (bodyArgument == null) {
            JsonMediaTypeCodec jsonCodec = this.lambdaContainerEnvironment.getJsonCodec();
            JsonNode decoded = (JsonNode)jsonCodec.decode(JsonNode.class, body);
            return Optional.of(decoded);
        }
        JsonMediaTypeCodec jsonCodec = this.lambdaContainerEnvironment.getJsonCodec();
        if (MicronautLambdaContainerHandler.nestedBody(bodyArgument)) {
            return Optional.of(new ConvertibleValuesMap((Map)jsonCodec.decode(Argument.of(Map.class), body)));
        }
        return Optional.of(jsonCodec.decode(bodyArgument, body));
    }

    @NonNull
    private static Optional<Map<String, List<String>>> formUrlEncodedBodyToMap(@NonNull String body) {
        QueryStringDecoder decoder = new QueryStringDecoder(body, false);
        Map<String, List<String>> parameters = decoder.parameters();
        return CollectionUtils.isEmpty(parameters) ? Optional.empty() : Optional.of(parameters);
    }

    @Nullable
    private static ConvertibleValues<?> formUrlEncodedBodyToConvertibleValues(@NonNull String body) {
        return MicronautLambdaContainerHandler.formUrlEncodedBodyToMap(body).map(ConvertibleValuesMap::new).orElse(null);
    }

    private static boolean nestedBody(@NonNull Argument<?> bodyArgument) {
        AnnotationMetadata annotationMetadata = bodyArgument.getAnnotationMetadata();
        if (annotationMetadata.hasAnnotation(Body.class)) {
            return annotationMetadata.stringValue(Body.class).isPresent();
        }
        return false;
    }

    @NonNull
    private Optional<Object> bindFormUrlEncoded(@NonNull Argument<?> argument, @NonNull String formUrlEncodedString) {
        return MicronautLambdaContainerHandler.formUrlEncodedBodyToMap(formUrlEncodedString).flatMap(parameters -> this.bindFormUrlEncoded(argument, (Map<String, List<String>>)parameters));
    }

    @NonNull
    private Optional<Object> bindFormUrlEncoded(@NonNull Argument<?> argument, @NonNull Map<String, List<String>> bodyParameters) {
        HashMap<CharSequence, List<String>> source = new HashMap<CharSequence, List<String>>();
        for (Map.Entry<String, List<String>> entry : bodyParameters.entrySet()) {
            source.put(entry.getKey(), entry.getValue());
        }
        try {
            return Optional.of(this.beanPropertyBinder.bind(argument.getType(), source));
        }
        catch (ConversionErrorException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Unable to convert to {}", (Object)argument.getType().getSimpleName(), (Object)e);
            }
            return Optional.empty();
        }
    }

    private Mono<MutableHttpResponse<?>> convertResponseBody(MicronautAwsProxyResponse<?> containerResponse, RouteInfo<?> routeInfo, Object body) {
        if (Publishers.isConvertibleToPublisher((Object)body)) {
            Mono single = Publishers.isSingle(body.getClass()) || routeInfo.getReturnType().isSpecifiedSingle() ? Mono.from((Publisher)((Publisher)Publishers.convertPublisher((Object)body, Publisher.class))) : Flux.from((Publisher)((Publisher)Publishers.convertPublisher((Object)body, Publisher.class))).collectList();
            return single.map(o -> {
                if (!(o instanceof MicronautAwsProxyResponse)) {
                    containerResponse.body(o);
                }
                this.applyRouteConfig(containerResponse, routeInfo);
                return containerResponse;
            });
        }
        if (!(body instanceof MicronautAwsProxyResponse)) {
            this.applyRouteConfig(containerResponse, routeInfo);
            containerResponse.body(body);
        }
        return Mono.just(containerResponse);
    }

    private void applyRouteConfig(MicronautAwsProxyResponse<?> containerResponse, RouteInfo<?> finalRoute) {
        if (!containerResponse.getContentType().isPresent()) {
            finalRoute.getAnnotationMetadata().getValue(Produces.class, String.class).ifPresent(arg_0 -> containerResponse.contentType(arg_0));
        }
        finalRoute.getAnnotationMetadata().getValue(Status.class, HttpStatus.class).ifPresent(httpStatus -> containerResponse.status((HttpStatus)httpStatus));
    }

    private void handlePossibleErrorStatus(MicronautAwsProxyRequest<?> request, MicronautAwsProxyResponse<?> response) {
        MediaType contentType = request.getContentType().orElse(null);
        String requestMethodName = request.getMethodName();
        List anyMatchingRoutes = this.router.findAny((CharSequence)request.getPath(), request).collect(Collectors.toList());
        Collection acceptedTypes = request.accept();
        boolean hasAcceptHeader = CollectionUtils.isNotEmpty((Collection)acceptedTypes);
        HashSet acceptableContentTypes = contentType != null ? new HashSet(5) : null;
        HashSet<String> allowedMethods = new HashSet<String>(5);
        HashSet produceableContentTypes = hasAcceptHeader ? new HashSet(5) : null;
        for (UriRouteMatch anyRoute : anyMatchingRoutes) {
            String routeMethod = anyRoute.getRoute().getHttpMethodName();
            if (!requestMethodName.equals(routeMethod)) {
                allowedMethods.add(routeMethod);
            }
            if (contentType != null && !anyRoute.doesConsume(contentType)) {
                acceptableContentTypes.addAll(anyRoute.getRoute().getConsumes());
            }
            if (!hasAcceptHeader || anyRoute.doesProduce(acceptedTypes)) continue;
            produceableContentTypes.addAll(anyRoute.getRoute().getProduces());
        }
        if (CollectionUtils.isNotEmpty(acceptableContentTypes)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Content type not allowed for URI {}, method {}, and content type {}", new Object[]{request.getUri(), requestMethodName, contentType});
            }
            this.handleStatusError(request, response, HttpResponse.status((HttpStatus)HttpStatus.UNSUPPORTED_MEDIA_TYPE), "Content Type [" + contentType + "] not allowed. Allowed types: " + acceptableContentTypes);
            return;
        }
        if (CollectionUtils.isNotEmpty(produceableContentTypes)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Content type not allowed for URI {}, method {}, and content type {}", new Object[]{request.getUri(), requestMethodName, contentType});
            }
            this.handleStatusError(request, response, HttpResponse.status((HttpStatus)HttpStatus.NOT_ACCEPTABLE), "Specified Accept Types " + acceptedTypes + " not supported. Supported types: " + produceableContentTypes);
            return;
        }
        if (!allowedMethods.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Method not allowed for URI {} and method {}", (Object)request.getUri(), (Object)requestMethodName);
            }
            this.handleStatusError(request, response, HttpResponse.notAllowedGeneric(allowedMethods), "Method [" + requestMethodName + "] not allowed for URI [" + request.getUri() + "]. Allowed methods: " + allowedMethods);
            return;
        }
        this.handleStatusError(request, response, HttpResponse.notFound(), "Page Not Found");
    }

    private void handleStatusError(MicronautAwsProxyRequest<?> request, MicronautAwsProxyResponse<?> response, MutableHttpResponse<?> defaultResponse, String message) {
        Optional statusRoute = this.router.findStatusRoute(defaultResponse.status(), request);
        if (statusRoute.isPresent()) {
            this.handleRouteMatch((RouteMatch)statusRoute.get(), request, response);
        } else {
            if (request.getMethod() != HttpMethod.HEAD && !(defaultResponse = this.errorResponseProcessor.processResponse(ErrorContext.builder(request).errorMessage(message).build(), defaultResponse)).getContentType().isPresent()) {
                defaultResponse = defaultResponse.contentType(MediaType.APPLICATION_JSON_TYPE);
            }
            this.filterAndEncodeResponse(request, response, Publishers.just(defaultResponse));
        }
    }

    private void filterAndEncodeResponse(final MicronautAwsProxyRequest<?> request, final MicronautAwsProxyResponse<?> response, Publisher<MutableHttpResponse<?>> responsePublisher) {
        AtomicReference requestReference = new AtomicReference(request);
        Flux.from((Publisher)this.routeExecutor.filterPublisher(requestReference, responsePublisher)).contextWrite(ctx -> ctx.put((Object)"micronaut.http.server.request", (Object)request)).subscribe(new Subscriber<MutableHttpResponse<?>>(){
            Subscription subscription;

            public void onSubscribe(Subscription s) {
                this.subscription = s;
                s.request(1L);
            }

            public void onNext(MutableHttpResponse<?> message) {
                MicronautLambdaContainerHandler.this.toAwsProxyResponse(response, message);
                this.subscription.request(1L);
            }

            public void onError(Throwable t) {
                try {
                    MutableHttpResponse defaultErrorResponse = MicronautLambdaContainerHandler.this.routeExecutor.createDefaultErrorResponse((HttpRequest)request, t);
                    MicronautLambdaContainerHandler.this.toAwsProxyResponse(response, (HttpResponse)defaultErrorResponse);
                }
                finally {
                    response.close();
                }
            }

            public void onComplete() {
                response.close();
            }
        });
    }

    @Override
    public void close() {
        this.applicationContext.close();
    }

    private static class LambdaContainerState
    implements MicronautLambdaContainerContext {
        private Router router;
        private ApplicationContext applicationContext;
        private JsonMediaTypeCodec jsonCodec;
        private ObjectMapper objectMapper;

        private LambdaContainerState() {
        }

        @Override
        public Router getRouter() {
            return this.router;
        }

        @Override
        public JsonMediaTypeCodec getJsonCodec() {
            return this.jsonCodec;
        }

        public ApplicationContext getApplicationContext() {
            return this.applicationContext;
        }

        @Override
        public ObjectMapper getObjectMapper() {
            return this.objectMapper;
        }

        void setJsonCodec(JsonMediaTypeCodec jsonCodec) {
            this.jsonCodec = jsonCodec;
        }

        void setRouter(Router router) {
            this.router = router;
        }

        void setApplicationContext(ApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
        }

        void setObjectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
        }
    }
}

