/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws.proxy;

import io.micronaut.core.annotation.Internal;
import jakarta.inject.Singleton;
import java.util.HashSet;
import java.util.Set;

@Internal
@Singleton
public final class BinaryContentConfiguration {
    private final Set<String> binaryContentTypes = new HashSet<String>();

    public BinaryContentConfiguration() {
        this.binaryContentTypes.addAll(Set.of("application/octet-stream", "image/jpeg", "image/png", "image/gif", "application/zip"));
    }

    public void addBinaryContentType(String contentType) {
        this.binaryContentTypes.add(contentType);
    }

    public boolean isBinary(String contentType) {
        if (contentType != null) {
            int semidx = contentType.indexOf(59);
            if (semidx > -1) {
                return this.binaryContentTypes.contains(contentType.substring(0, semidx).trim());
            }
            return this.binaryContentTypes.contains(contentType.trim());
        }
        return false;
    }
}

