/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws.proxy;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.MutableHttpHeaders;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Internal
public final class MapCollapseUtils {
    private MapCollapseUtils() {
    }

    public static Map<String, String> getSingleValueHeaders(MutableHttpHeaders headers) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String paramName : headers.names()) {
            result.put(paramName, (String)headers.get((CharSequence)paramName));
        }
        return result;
    }

    public static Map<String, List<String>> getMultiHeaders(MutableHttpHeaders headers) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (String paramName : headers.names()) {
            result.put(paramName, headers.getAll((CharSequence)paramName));
        }
        return result;
    }

    public static Map<String, List<String>> collapse(Map<String, List<String>> multi, Map<String, String> single) {
        if (multi == null && single == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> values = new HashMap<String, List<String>>();
        if (multi != null) {
            for (Map.Entry<String, Object> entry : multi.entrySet()) {
                values.computeIfAbsent(entry.getKey(), s -> new ArrayList()).addAll((Collection)entry.getValue());
            }
        }
        if (CollectionUtils.isNotEmpty(single)) {
            for (Map.Entry<String, Object> entry : single.entrySet()) {
                List strings = values.computeIfAbsent(entry.getKey(), s -> new ArrayList());
                if (strings.contains(entry.getValue())) continue;
                strings.add((String)entry.getValue());
            }
        }
        return values;
    }

    public static Map<String, String> collapse(Map<String, List<String>> input) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : input.entrySet()) {
            result.put(entry.getKey(), String.join((CharSequence)",", (Iterable<? extends CharSequence>)entry.getValue()));
        }
        return result;
    }
}

