/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws.proxy.payload1;

import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyResponseEvent;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.util.StringUtils;
import io.micronaut.function.aws.proxy.ApiGatewayServletRequest;
import io.micronaut.function.aws.proxy.payload1.ApiGatewayProxyServletResponse;
import io.micronaut.http.CaseInsensitiveMutableHttpHeaders;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpParameters;
import io.micronaut.servlet.http.BodyBuilder;
import io.micronaut.servlet.http.ServletHttpResponse;
import java.io.IOException;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class ApiGatewayProxyServletRequest<B>
extends ApiGatewayServletRequest<B, APIGatewayProxyRequestEvent, APIGatewayProxyResponseEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(ApiGatewayProxyServletRequest.class);
    private final ApiGatewayProxyServletResponse<?> response;

    public ApiGatewayProxyServletRequest(APIGatewayProxyRequestEvent requestEvent, ApiGatewayProxyServletResponse<Object> response, ConversionService conversionService, BodyBuilder bodyBuilder) {
        super(conversionService, requestEvent, ApiGatewayServletRequest.buildUri(requestEvent.getPath(), requestEvent.getQueryStringParameters(), requestEvent.getMultiValueQueryStringParameters()), ApiGatewayProxyServletRequest.parseMethod(() -> ((APIGatewayProxyRequestEvent)requestEvent).getHttpMethod()), LOG, bodyBuilder);
        this.response = response;
    }

    @Override
    public byte[] getBodyBytes() throws IOException {
        String body = ((APIGatewayProxyRequestEvent)this.requestEvent).getBody();
        if (StringUtils.isEmpty((CharSequence)body)) {
            throw new IOException("Empty Body");
        }
        Boolean isBase64Encoded = ((APIGatewayProxyRequestEvent)this.requestEvent).getIsBase64Encoded();
        return Boolean.TRUE.equals(isBase64Encoded) ? Base64.getDecoder().decode(body) : body.getBytes(this.getCharacterEncoding());
    }

    public MutableHttpHeaders getHeaders() {
        Map multiValueHeaders = ((APIGatewayProxyRequestEvent)this.requestEvent).getMultiValueHeaders();
        return new CaseInsensitiveMutableHttpHeaders(multiValueHeaders != null ? multiValueHeaders : Collections.emptyMap(), this.conversionService);
    }

    public MutableHttpParameters getParameters() {
        return this.getParameters(() -> ((APIGatewayProxyRequestEvent)((APIGatewayProxyRequestEvent)this.requestEvent)).getQueryStringParameters(), () -> ((APIGatewayProxyRequestEvent)((APIGatewayProxyRequestEvent)this.requestEvent)).getMultiValueQueryStringParameters());
    }

    public ServletHttpResponse<APIGatewayProxyResponseEvent, ?> getResponse() {
        return this.response;
    }
}

