/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws.proxy.alb;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.amazonaws.services.lambda.runtime.events.ApplicationLoadBalancerRequestEvent;
import com.amazonaws.services.lambda.runtime.events.ApplicationLoadBalancerResponseEvent;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.context.ApplicationContextProvider;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.function.aws.HandlerUtils;
import io.micronaut.function.aws.LambdaApplicationContextBuilder;
import io.micronaut.function.aws.proxy.alb.ApplicationLoadBalancerHandler;
import io.micronaut.function.executor.FunctionInitializer;
import io.micronaut.servlet.http.ServletHttpHandler;

public class ApplicationLoadBalancerFunction
extends FunctionInitializer
implements RequestHandler<ApplicationLoadBalancerRequestEvent, ApplicationLoadBalancerResponseEvent> {
    private final ServletHttpHandler<ApplicationLoadBalancerRequestEvent, ApplicationLoadBalancerResponseEvent> httpHandler;

    public ApplicationLoadBalancerFunction() {
        this.httpHandler = this.initializeHandler();
    }

    public ApplicationLoadBalancerFunction(ApplicationContext ctx) {
        super(ctx);
        this.startThis(this.applicationContext);
        this.httpHandler = this.initializeHandler();
    }

    private ServletHttpHandler<ApplicationLoadBalancerRequestEvent, ApplicationLoadBalancerResponseEvent> initializeHandler() {
        ApplicationLoadBalancerHandler applicationLoadBalancerHandler = new ApplicationLoadBalancerHandler(this.applicationContext);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((ApplicationLoadBalancerHandler)applicationLoadBalancerHandler).close()));
        return applicationLoadBalancerHandler;
    }

    public ApplicationLoadBalancerResponseEvent handleRequest(ApplicationLoadBalancerRequestEvent input, Context context) {
        HandlerUtils.configureWithContext((ApplicationContextProvider)this, (Context)context);
        return (ApplicationLoadBalancerResponseEvent)this.httpHandler.exchange((Object)input, (Object)new ApplicationLoadBalancerResponseEvent()).getResponse().getNativeResponse();
    }

    @NonNull
    protected ApplicationContextBuilder newApplicationContextBuilder() {
        return new LambdaApplicationContextBuilder();
    }
}

