/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws.proxy.alb;

import com.amazonaws.services.lambda.runtime.events.ApplicationLoadBalancerResponseEvent;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.function.aws.proxy.MapCollapseUtils;
import io.micronaut.http.CaseInsensitiveMutableHttpHeaders;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.cookie.Cookie;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

@Internal
public class ApplicationLoadBalancerResponseEventAdapter<T>
implements MutableHttpResponse<T> {
    private ApplicationLoadBalancerResponseEvent event;
    private final ConversionService conversionService;
    private final MutableConvertibleValues<Object> attributes = new MutableConvertibleValuesMap();
    private Map<String, Cookie> cookies = new ConcurrentHashMap<String, Cookie>(2);
    private Integer status;
    private String reason;

    public ApplicationLoadBalancerResponseEventAdapter(ApplicationLoadBalancerResponseEvent event, ConversionService conversionService) {
        this.event = event;
        this.conversionService = conversionService;
    }

    public MutableHttpResponse<T> cookie(Cookie cookie) {
        this.cookies.put(cookie.getName(), cookie);
        return this;
    }

    public MutableHttpHeaders getHeaders() {
        return new CaseInsensitiveMutableHttpHeaders(MapCollapseUtils.collapse(this.event.getMultiValueHeaders(), this.event.getHeaders()), this.conversionService);
    }

    public MutableConvertibleValues<Object> getAttributes() {
        return this.attributes;
    }

    public Optional<T> getBody() {
        if (this.event.getIsBase64Encoded()) {
            return Optional.ofNullable(Base64.getDecoder().decode(this.event.getBody()));
        }
        return Optional.ofNullable(this.event.getBody());
    }

    public <B> MutableHttpResponse<B> body(B body) {
        return this;
    }

    public MutableHttpResponse<T> status(int status, CharSequence message) {
        ArgumentUtils.requireNonNull((String)"status", (Object)status);
        this.reason = message == null ? HttpStatus.getDefaultReason((int)status) : message.toString();
        this.status = status;
        return this;
    }

    public int code() {
        if (this.status != null) {
            return this.status;
        }
        return this.getStatus().getCode();
    }

    public String reason() {
        if (this.reason != null) {
            return this.reason;
        }
        return this.getStatus().getReason();
    }

    public HttpStatus getStatus() {
        return HttpStatus.valueOf((int)(this.status == null ? this.event.getStatusCode() : this.status.intValue()));
    }
}

