/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws.proxy.alb;

import com.amazonaws.services.lambda.runtime.events.ApplicationLoadBalancerResponseEvent;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.util.StringUtils;
import io.micronaut.function.BinaryTypeConfiguration;
import io.micronaut.function.aws.proxy.AbstractServletHttpResponse;
import io.micronaut.function.aws.proxy.MapCollapseUtils;
import java.util.Base64;

@Internal
public class ApplicationLoadBalancerServletResponse<B>
extends AbstractServletHttpResponse<ApplicationLoadBalancerResponseEvent, B> {
    protected ApplicationLoadBalancerServletResponse(ConversionService conversionService, BinaryTypeConfiguration binaryTypeConfiguration) {
        super(conversionService, binaryTypeConfiguration);
    }

    public ApplicationLoadBalancerResponseEvent getNativeResponse() {
        ApplicationLoadBalancerResponseEvent nativeResponse = new ApplicationLoadBalancerResponseEvent();
        nativeResponse.setHeaders(MapCollapseUtils.getSingleValueHeaders(this.headers));
        nativeResponse.setMultiValueHeaders(MapCollapseUtils.getMultiHeaders(this.headers));
        nativeResponse.setStatusCode(this.status);
        if (this.binaryTypeConfiguration.isMediaTypeBinary((String)this.getHeaders().getContentType().orElse(null))) {
            nativeResponse.setIsBase64Encoded(true);
            nativeResponse.setBody(Base64.getEncoder().encodeToString(this.body.toByteArray()));
        } else {
            nativeResponse.setIsBase64Encoded(false);
            String bodyStr = this.body.toString(this.getCharacterEncoding());
            if (StringUtils.isNotEmpty((CharSequence)bodyStr)) {
                nativeResponse.setBody(bodyStr);
            }
        }
        return nativeResponse;
    }
}

