/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws.proxy.security;

import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayV2HTTPEvent;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.filters.AuthenticationFetcher;
import io.micronaut.servlet.http.ServletHttpRequest;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.reactivestreams.Publisher;

@Singleton
@Requires(classes={AuthenticationFetcher.class})
public class MicronautLambdaAuthenticationFetcher
implements AuthenticationFetcher<HttpRequest<?>> {
    private static final String HEADER_OIDC_IDENTITY = "x-amzn-oidc-identity";
    private static final String CLAIM_SUB = "sub";
    private static final String CLAIMS = "claims";

    public Publisher<Authentication> fetchAuthentication(HttpRequest<?> request) {
        Optional<Authentication> optionalAuthentication = Optional.empty();
        if (request instanceof ServletHttpRequest) {
            ServletHttpRequest servletHttpRequest = (ServletHttpRequest)request;
            Object nativeRequest = servletHttpRequest.getNativeRequest();
            if (nativeRequest instanceof APIGatewayV2HTTPEvent) {
                APIGatewayV2HTTPEvent aPIGatewayV2HTTPEvent = (APIGatewayV2HTTPEvent)nativeRequest;
                optionalAuthentication = this.fetchAuthentication(aPIGatewayV2HTTPEvent);
            } else if (nativeRequest instanceof APIGatewayProxyRequestEvent) {
                APIGatewayProxyRequestEvent apiGatewayProxyRequestEvent = (APIGatewayProxyRequestEvent)nativeRequest;
                optionalAuthentication = this.fetchAuthentication(apiGatewayProxyRequestEvent);
            }
        }
        if (optionalAuthentication.isEmpty()) {
            optionalAuthentication = this.fetchAuthenticationFromHeader(request);
        }
        return optionalAuthentication.map(Publishers::just).orElseGet(Publishers::empty);
    }

    private Optional<Authentication> fetchAuthenticationFromHeader(HttpRequest<?> request) {
        String v = (String)request.getHeaders().get((CharSequence)HEADER_OIDC_IDENTITY);
        if (v != null) {
            return Optional.of(Authentication.build((String)v, Collections.emptyMap()));
        }
        return Optional.empty();
    }

    private Optional<Authentication> fetchAuthentication(APIGatewayProxyRequestEvent request) {
        Object object;
        APIGatewayProxyRequestEvent.ProxyRequestContext proxyRequestContext = request.getRequestContext();
        Map authorizer = proxyRequestContext.getAuthorizer();
        if (authorizer == null) {
            return Optional.empty();
        }
        if (authorizer.containsKey(CLAIM_SUB)) {
            return this.fetchAuthentication(authorizer);
        }
        if (authorizer.containsKey(CLAIMS) && (object = authorizer.get(CLAIMS)) instanceof Map) {
            return this.fetchAuthentication((Map)object);
        }
        return Optional.empty();
    }

    private Optional<Authentication> fetchAuthentication(APIGatewayV2HTTPEvent request) {
        HashMap claims;
        Object subject;
        APIGatewayV2HTTPEvent.RequestContext.Authorizer.JWT jwt;
        APIGatewayV2HTTPEvent.RequestContext.Authorizer authorizer;
        if (request.getRequestContext() != null && (authorizer = request.getRequestContext().getAuthorizer()) != null && (jwt = authorizer.getJwt()) != null && jwt.getClaims() != null && (subject = (claims = new HashMap(jwt.getClaims())).get(CLAIM_SUB)) != null) {
            return Optional.of(Authentication.build((String)subject.toString(), claims));
        }
        return Optional.empty();
    }

    @NonNull
    private Optional<Authentication> fetchAuthentication(@NonNull Map<String, Object> claims) {
        Object subject = claims.get(CLAIM_SUB);
        if (subject != null) {
            return Optional.of(Authentication.build((String)subject.toString(), claims));
        }
        return Optional.empty();
    }
}

