/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws.proxy.payload1;

import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyResponseEvent;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.util.StringUtils;
import io.micronaut.function.BinaryTypeConfiguration;
import io.micronaut.function.aws.proxy.AbstractServletHttpResponse;
import io.micronaut.function.aws.proxy.MapCollapseUtils;
import java.util.Base64;

@Internal
public class ApiGatewayProxyServletResponse<B>
extends AbstractServletHttpResponse<APIGatewayProxyResponseEvent, B> {
    protected ApiGatewayProxyServletResponse(ConversionService conversionService, BinaryTypeConfiguration binaryTypeConfiguration) {
        super(conversionService, binaryTypeConfiguration);
    }

    public APIGatewayProxyResponseEvent getNativeResponse() {
        APIGatewayProxyResponseEvent apiGatewayProxyResponseEvent = new APIGatewayProxyResponseEvent().withStatusCode(Integer.valueOf(this.status)).withMultiValueHeaders(MapCollapseUtils.getMultiHeaders(this.headers)).withHeaders(MapCollapseUtils.getSingleValueHeaders(this.headers));
        if (this.binaryTypeConfiguration.isMediaTypeBinary((String)this.getHeaders().getContentType().orElse(null))) {
            apiGatewayProxyResponseEvent.withIsBase64Encoded(Boolean.valueOf(true)).withBody(Base64.getEncoder().encodeToString(this.body.toByteArray()));
        } else {
            apiGatewayProxyResponseEvent.withIsBase64Encoded(Boolean.valueOf(false));
            String bodyStr = this.body.toString(this.getCharacterEncoding());
            if (StringUtils.isNotEmpty((CharSequence)bodyStr)) {
                apiGatewayProxyResponseEvent.withBody(bodyStr);
            }
        }
        return apiGatewayProxyResponseEvent;
    }
}

