/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws.proxy;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.function.BinaryTypeConfiguration;
import io.micronaut.http.CaseInsensitiveMutableHttpHeaders;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.ServerCookieEncoder;
import io.micronaut.servlet.http.ServletHttpResponse;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Optional;

@Internal
public abstract class AbstractServletHttpResponse<R, B>
implements ServletHttpResponse<R, B> {
    protected final ByteArrayOutputStream body = new ByteArrayOutputStream();
    protected int status = HttpStatus.OK.getCode();
    protected final MutableHttpHeaders headers;
    protected final BinaryTypeConfiguration binaryTypeConfiguration;
    private MutableConvertibleValues<Object> attributes;
    private B bodyObject;
    private String reason = HttpStatus.OK.getReason();

    protected AbstractServletHttpResponse(ConversionService conversionService, BinaryTypeConfiguration binaryTypeConfiguration) {
        this.headers = new CaseInsensitiveMutableHttpHeaders(conversionService);
        this.binaryTypeConfiguration = binaryTypeConfiguration;
    }

    public OutputStream getOutputStream() {
        return this.body;
    }

    public BufferedWriter getWriter() {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)this.body, this.getCharacterEncoding()));
    }

    public MutableHttpResponse<B> cookie(Cookie cookie) {
        ServerCookieEncoder.INSTANCE.encode(new Cookie[]{cookie}).forEach(c -> this.header("Set-Cookie", (CharSequence)c));
        return this;
    }

    public MutableHttpHeaders getHeaders() {
        return this.headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableConvertibleValues<Object> getAttributes() {
        MutableConvertibleValuesMap localAttributes = this.attributes;
        if (localAttributes == null) {
            AbstractServletHttpResponse abstractServletHttpResponse = this;
            synchronized (abstractServletHttpResponse) {
                localAttributes = this.attributes;
                if (localAttributes == null) {
                    this.attributes = localAttributes = new MutableConvertibleValuesMap();
                }
            }
        }
        return localAttributes;
    }

    public Optional<B> getBody() {
        return Optional.ofNullable(this.bodyObject);
    }

    public <T> MutableHttpResponse<T> body(@Nullable T body) {
        this.bodyObject = body;
        return this;
    }

    public MutableHttpResponse<B> status(int status, CharSequence message) {
        this.status = status;
        this.reason = message == null ? HttpStatus.getDefaultReason((int)status) : message.toString();
        return this;
    }

    public int code() {
        return this.status;
    }

    public String reason() {
        return this.reason;
    }
}

