/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws.proxy;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.function.aws.proxy.AwsCookies;
import io.micronaut.function.aws.proxy.MapCollapseUtils;
import io.micronaut.function.aws.proxy.MapListOfStringAndMapStringMutableHttpParameters;
import io.micronaut.function.aws.proxy.QueryStringDecoder;
import io.micronaut.http.CaseInsensitiveMutableHttpHeaders;
import io.micronaut.http.FullHttpRequest;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpParameters;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.Cookies;
import io.micronaut.http.uri.UriBuilder;
import io.micronaut.servlet.http.BodyBuilder;
import io.micronaut.servlet.http.ByteArrayByteBuffer;
import io.micronaut.servlet.http.MutableServletHttpRequest;
import io.micronaut.servlet.http.ParsedBodyHolder;
import io.micronaut.servlet.http.ServletExchange;
import io.micronaut.servlet.http.ServletHttpRequest;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.slf4j.Logger;

@Internal
public abstract class ApiGatewayServletRequest<T, REQ, RES>
implements MutableServletHttpRequest<REQ, T>,
ServletExchange<REQ, RES>,
FullHttpRequest<T>,
ParsedBodyHolder<T> {
    private static final Set<Class<?>> RAW_BODY_TYPES = CollectionUtils.setOf((Object[])new Class[]{String.class, byte[].class, ByteBuffer.class, InputStream.class});
    private static final String SLASH = "/";
    protected ConversionService conversionService;
    protected final REQ requestEvent;
    private URI uri;
    private final HttpMethod httpMethod;
    private final Logger log;
    private Cookies cookies;
    private MutableConvertibleValues<Object> attributes;
    private Supplier<Optional<T>> body;
    private T parsedBody;
    private T overriddenBody;
    private ByteArrayByteBuffer<T> servletByteBuffer;

    protected ApiGatewayServletRequest(ConversionService conversionService, REQ request, URI uri, HttpMethod httpMethod, Logger log, BodyBuilder bodyBuilder) {
        this.conversionService = conversionService;
        this.requestEvent = request;
        this.uri = uri;
        this.httpMethod = httpMethod;
        this.log = log;
        this.body = SupplierUtil.memoizedNonEmpty(() -> {
            T built = this.parsedBody != null ? this.parsedBody : bodyBuilder.buildBody(this::getInputStream, (HttpRequest)this);
            return Optional.ofNullable(built);
        });
    }

    public abstract byte[] getBodyBytes() throws IOException;

    protected static URI buildUri(@Nullable String path, @Nullable Map<String, String> queryParameters, @Nullable Map<String, List<String>> multiQueryParameters) {
        UriBuilder uriBuilder = UriBuilder.of((CharSequence)(path == null ? SLASH : path));
        if (CollectionUtils.isNotEmpty(multiQueryParameters)) {
            multiQueryParameters.forEach((key, values) -> uriBuilder.queryParam(key, values.toArray()));
        } else if (CollectionUtils.isNotEmpty(queryParameters)) {
            queryParameters.forEach((x$0, xva$1) -> uriBuilder.queryParam(x$0, new Object[]{xva$1}));
        }
        return uriBuilder.build();
    }

    protected static HttpMethod parseMethod(Supplier<String> httpMethodConsumer) {
        try {
            return HttpMethod.valueOf((String)httpMethodConsumer.get());
        }
        catch (IllegalArgumentException e) {
            return HttpMethod.CUSTOM;
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.servletByteBuffer != null ? this.servletByteBuffer.toInputStream() : new ByteArrayInputStream(this.getBodyBytes());
    }

    public ServletHttpRequest<REQ, ? super Object> getRequest() {
        return this;
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader(this.getInputStream(), this.getCharacterEncoding()));
    }

    public REQ getNativeRequest() {
        return this.requestEvent;
    }

    public HttpMethod getMethod() {
        return this.httpMethod;
    }

    public URI getUri() {
        return this.uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Cookies getCookies() {
        Cookies localCookies = this.cookies;
        if (localCookies == null) {
            ApiGatewayServletRequest apiGatewayServletRequest = this;
            synchronized (apiGatewayServletRequest) {
                localCookies = this.cookies;
                if (localCookies == null) {
                    this.cookies = localCookies = new AwsCookies(this.getPath(), (HttpHeaders)this.getHeaders(), this.conversionService);
                }
            }
        }
        return localCookies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableConvertibleValues<Object> getAttributes() {
        MutableConvertibleValuesMap localAttributes = this.attributes;
        if (localAttributes == null) {
            ApiGatewayServletRequest apiGatewayServletRequest = this;
            synchronized (apiGatewayServletRequest) {
                localAttributes = this.attributes;
                if (localAttributes == null) {
                    this.attributes = localAttributes = new MutableConvertibleValuesMap();
                }
            }
        }
        return localAttributes;
    }

    @NonNull
    public Optional<T> getBody() {
        if (this.overriddenBody != null) {
            return Optional.of(this.overriddenBody);
        }
        return this.body.get();
    }

    @NonNull
    public <B> Optional<B> getBody(Argument<B> arg) {
        return this.getBody().map(t -> this.conversionService.convertRequired(t, arg));
    }

    protected boolean isFormSubmission(MediaType contentType) {
        return MediaType.APPLICATION_FORM_URLENCODED_TYPE.equals((Object)contentType) || MediaType.MULTIPART_FORM_DATA_TYPE.equals((Object)contentType);
    }

    public MutableHttpRequest<T> cookie(Cookie cookie) {
        return this;
    }

    public MutableHttpRequest<T> uri(URI uri) {
        this.uri = uri;
        return this;
    }

    public <B> MutableHttpRequest<B> body(B body) {
        this.overriddenBody = body;
        return this;
    }

    protected MapListOfStringAndMapStringMutableHttpParameters getParametersFromBody(Map<String, String> queryStringParameters) {
        Map<String, List<String>> parameters;
        block2: {
            parameters = null;
            try {
                parameters = new QueryStringDecoder(new String(this.getBodyBytes(), this.getCharacterEncoding()), false).parameters();
            }
            catch (IOException ex) {
                if (!this.log.isDebugEnabled()) break block2;
                this.log.debug("Error decoding form data: " + ex.getMessage(), (Throwable)ex);
            }
        }
        return new MapListOfStringAndMapStringMutableHttpParameters(this.conversionService, parameters, queryStringParameters);
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public void setParsedBody(T body) {
        this.parsedBody = body;
    }

    @Nullable
    public ByteBuffer<?> contents() {
        try {
            if (this.servletByteBuffer == null) {
                this.servletByteBuffer = new ByteArrayByteBuffer(this.getInputStream().readAllBytes());
            }
            return this.servletByteBuffer;
        }
        catch (IOException e) {
            throw new IllegalStateException("Error getting all body contents", e);
        }
    }

    @Nullable
    public ExecutionFlow<ByteBuffer<?>> bufferContents() {
        ByteBuffer<?> contents = this.contents();
        if (contents == null) {
            return null;
        }
        return ExecutionFlow.just(contents);
    }

    protected byte[] getBodyBytes(@NonNull Supplier<String> bodySupplier, @NonNull BooleanSupplier base64EncodedSupplier) throws IOException {
        String requestBody = bodySupplier.get();
        if (StringUtils.isEmpty((CharSequence)requestBody)) {
            throw new IOException("Empty Body");
        }
        return base64EncodedSupplier.getAsBoolean() ? Base64.getDecoder().decode(requestBody) : requestBody.getBytes(this.getCharacterEncoding());
    }

    @NonNull
    protected static List<String> splitCommaSeparatedValue(@Nullable String value) {
        if (value == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(value.split(","));
    }

    @NonNull
    protected static Map<String, List<String>> transformCommaSeparatedValue(@Nullable Map<String, String> input) {
        if (input == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> output = new HashMap<String, List<String>>();
        for (Map.Entry<String, String> entry : input.entrySet()) {
            output.put(entry.getKey(), ApiGatewayServletRequest.splitCommaSeparatedValue(entry.getValue()));
        }
        return output;
    }

    @NonNull
    protected MutableHttpParameters getParameters(@NonNull Supplier<Map<String, String>> queryStringParametersSupplier, @NonNull Supplier<Map<String, List<String>>> multiQueryStringParametersSupplier) {
        Map<String, List<String>> multi = multiQueryStringParametersSupplier.get();
        Map<String, String> single = queryStringParametersSupplier.get();
        MediaType mediaType = this.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
        if (this.isFormSubmission(mediaType)) {
            return this.getParametersFromBody(MapCollapseUtils.collapse(MapCollapseUtils.collapse(multi, single)));
        }
        return new MapListOfStringAndMapStringMutableHttpParameters(this.conversionService, multi, single);
    }

    @NonNull
    protected MutableHttpHeaders getHeaders(@NonNull Supplier<Map<String, String>> singleHeaders, @NonNull Supplier<Map<String, List<String>>> multiValueHeaders) {
        return new CaseInsensitiveMutableHttpHeaders(MapCollapseUtils.collapse(multiValueHeaders.get(), singleHeaders.get()), this.conversionService);
    }
}

