/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws.proxy.alb;

import com.amazonaws.services.lambda.runtime.events.ApplicationLoadBalancerRequestEvent;
import com.amazonaws.services.lambda.runtime.events.ApplicationLoadBalancerResponseEvent;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.function.aws.proxy.ApiGatewayServletRequest;
import io.micronaut.function.aws.proxy.alb.ApplicationLoadBalancerServletResponse;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpParameters;
import io.micronaut.servlet.http.BodyBuilder;
import io.micronaut.servlet.http.ServletHttpResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class ApplicationLoadBalancerServletRequest<B>
extends ApiGatewayServletRequest<B, ApplicationLoadBalancerRequestEvent, ApplicationLoadBalancerResponseEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationLoadBalancerServletRequest.class);
    private final ApplicationLoadBalancerServletResponse<Object> response;

    public ApplicationLoadBalancerServletRequest(ApplicationLoadBalancerRequestEvent requestEvent, ApplicationLoadBalancerServletResponse<Object> response, ConversionService conversionService, BodyBuilder bodyBuilder) {
        super(conversionService, requestEvent, ApiGatewayServletRequest.buildUri(requestEvent.getPath(), requestEvent.getQueryStringParameters(), requestEvent.getMultiValueQueryStringParameters()), ApplicationLoadBalancerServletRequest.parseMethod(() -> ((ApplicationLoadBalancerRequestEvent)requestEvent).getHttpMethod()), LOG, bodyBuilder);
        this.response = response;
    }

    @Override
    public byte[] getBodyBytes() throws IOException {
        return this.getBodyBytes(() -> ((ApplicationLoadBalancerRequestEvent)((ApplicationLoadBalancerRequestEvent)this.requestEvent)).getBody(), () -> ((ApplicationLoadBalancerRequestEvent)((ApplicationLoadBalancerRequestEvent)this.requestEvent)).getIsBase64Encoded());
    }

    public MutableHttpHeaders getHeaders() {
        return this.getHeaders(() -> ((ApplicationLoadBalancerRequestEvent)((ApplicationLoadBalancerRequestEvent)this.requestEvent)).getHeaders(), () -> ((ApplicationLoadBalancerRequestEvent)((ApplicationLoadBalancerRequestEvent)this.requestEvent)).getMultiValueHeaders());
    }

    public MutableHttpParameters getParameters() {
        return this.getParameters(() -> ((ApplicationLoadBalancerRequestEvent)((ApplicationLoadBalancerRequestEvent)this.requestEvent)).getQueryStringParameters(), () -> ((ApplicationLoadBalancerRequestEvent)((ApplicationLoadBalancerRequestEvent)this.requestEvent)).getMultiValueQueryStringParameters());
    }

    public ServletHttpResponse<ApplicationLoadBalancerResponseEvent, ?> getResponse() {
        return this.response;
    }
}

