/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws.proxy.payload1;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyResponseEvent;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.context.ApplicationContextProvider;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.function.aws.HandlerUtils;
import io.micronaut.function.aws.LambdaApplicationContextBuilder;
import io.micronaut.function.aws.proxy.payload1.ApiGatewayProxyEventHandler;
import io.micronaut.function.executor.FunctionInitializer;
import io.micronaut.servlet.http.ServletHttpHandler;

public class ApiGatewayProxyRequestEventFunction
extends FunctionInitializer
implements RequestHandler<APIGatewayProxyRequestEvent, APIGatewayProxyResponseEvent> {
    private final ServletHttpHandler<APIGatewayProxyRequestEvent, APIGatewayProxyResponseEvent> httpHandler;

    public ApiGatewayProxyRequestEventFunction() {
        this.httpHandler = this.initializeHandler();
    }

    public ApiGatewayProxyRequestEventFunction(ApplicationContext ctx) {
        super(ctx);
        this.startThis(this.applicationContext);
        this.httpHandler = this.initializeHandler();
    }

    private ServletHttpHandler<APIGatewayProxyRequestEvent, APIGatewayProxyResponseEvent> initializeHandler() {
        ApiGatewayProxyEventHandler apiGatewayProxyEventHandler = new ApiGatewayProxyEventHandler(this.applicationContext);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((ApiGatewayProxyEventHandler)apiGatewayProxyEventHandler).close()));
        return apiGatewayProxyEventHandler;
    }

    public APIGatewayProxyResponseEvent handleRequest(APIGatewayProxyRequestEvent input, Context context) {
        HandlerUtils.configureWithContext((ApplicationContextProvider)this, (Context)context);
        return (APIGatewayProxyResponseEvent)this.httpHandler.exchange((Object)input, (Object)new APIGatewayProxyResponseEvent()).getResponse().getNativeResponse();
    }

    @NonNull
    protected ApplicationContextBuilder newApplicationContextBuilder() {
        return new LambdaApplicationContextBuilder();
    }
}

