/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws.proxy;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleMultiValues;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.function.aws.proxy.MapCollapseUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@Internal
class MapListOfStringAndMapStringConvertibleMultiValue
implements ConvertibleMultiValues<String> {
    protected Map<String, List<String>> values;
    protected ConversionService conversionService;

    MapListOfStringAndMapStringConvertibleMultiValue(ConversionService conversionService, Map<String, List<String>> multi, Map<String, String> single) {
        this.conversionService = conversionService;
        this.values = MapCollapseUtils.collapse(multi, single);
    }

    public List<String> getAll(CharSequence name) {
        return this.getAllIgnoreCase(name.toString()).orElse(Collections.emptyList());
    }

    @Nullable
    public String get(CharSequence name) {
        List<String> valuesForName = this.getAll(name);
        if (CollectionUtils.isEmpty(valuesForName)) {
            return null;
        }
        return valuesForName.get(0);
    }

    public Set<String> names() {
        return this.values.keySet();
    }

    public Collection<List<String>> values() {
        return this.values.values();
    }

    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        String v = this.get(name);
        if (v != null) {
            return this.conversionService.convert((Object)v, conversionContext);
        }
        return Optional.empty();
    }

    @NonNull
    private Optional<List<String>> getAllIgnoreCase(@Nullable String headerName) {
        if (StringUtils.isEmpty((CharSequence)headerName)) {
            return Optional.empty();
        }
        List<String> l = this.values.get(headerName);
        if (l != null) {
            return Optional.of(l);
        }
        for (Map.Entry<String, List<String>> entry : this.values.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(headerName)) continue;
            return Optional.of(entry.getValue());
        }
        return Optional.empty();
    }
}

