/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws.runtime;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.function.aws.runtime.AbstractMicronautLambdaRuntime;
import io.micronaut.function.aws.runtime.AwsLambdaRuntimeApiError;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.uri.UriTemplate;
import java.util.Collections;

public interface AwsLambdaRuntimeApi {
    public static final String PATH_REQUEST_ID = "requestId";
    public static final UriTemplate INVOCATION_TEMPLATE = UriTemplate.of((String)"/2018-06-01/runtime/invocation/{requestId}/response");
    public static final UriTemplate ERROR_TEMPLATE = UriTemplate.of((String)"/2018-06-01/runtime/invocation/{requestId}/error");
    public static final String NEXT_INVOCATION_URI = "/2018-06-01/runtime/invocation/next";
    public static final String INIT_ERROR_URI = "/2018-06-01/runtime/init/error";
    public static final String LAMBDA_RUNTIME_FUNCTION_ERROR_TYPE = "Lambda-Runtime-Function-Error-Type";

    @NonNull
    default public String responseUri(@NonNull String requestId) {
        return INVOCATION_TEMPLATE.expand(Collections.singletonMap(PATH_REQUEST_ID, requestId));
    }

    @NonNull
    default public String errorUri(@NonNull String requestId) {
        return ERROR_TEMPLATE.expand(Collections.singletonMap(PATH_REQUEST_ID, requestId));
    }

    default public HttpRequest invocationResponseRequest(@NonNull String requestId, Object body) {
        return HttpRequest.POST((String)this.responseUri(requestId), (Object)body).header((CharSequence)"User-Agent", (CharSequence)AbstractMicronautLambdaRuntime.USER_AGENT_VALUE);
    }

    default public HttpRequest<AwsLambdaRuntimeApiError> invocationErrorRequest(@NonNull String requestId, @Nullable String errorMessage, @Nullable String errorType, @Nullable String lambdaFunctionErrorType) {
        AwsLambdaRuntimeApiError error = new AwsLambdaRuntimeApiError(errorMessage, errorType);
        MutableHttpRequest request = HttpRequest.POST((String)this.errorUri(requestId), (Object)error).header((CharSequence)"User-Agent", (CharSequence)AbstractMicronautLambdaRuntime.USER_AGENT_VALUE);
        if (lambdaFunctionErrorType != null) {
            return request.header((CharSequence)LAMBDA_RUNTIME_FUNCTION_ERROR_TYPE, (CharSequence)lambdaFunctionErrorType);
        }
        return request;
    }

    default public HttpRequest<AwsLambdaRuntimeApiError> initializationErrorRequest(@Nullable String errorMessage, @Nullable String errorType, @Nullable String lambdaFunctionErrorType) {
        AwsLambdaRuntimeApiError error = new AwsLambdaRuntimeApiError(errorMessage, errorType);
        MutableHttpRequest request = HttpRequest.POST((String)INIT_ERROR_URI, (Object)error).header((CharSequence)"User-Agent", (CharSequence)AbstractMicronautLambdaRuntime.USER_AGENT_VALUE);
        if (lambdaFunctionErrorType != null) {
            return request.header((CharSequence)LAMBDA_RUNTIME_FUNCTION_ERROR_TYPE, (CharSequence)lambdaFunctionErrorType);
        }
        return request;
    }
}

