/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws.runtime;

import com.amazonaws.services.lambda.runtime.ClientContext;
import com.amazonaws.services.lambda.runtime.CognitoIdentity;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.LambdaLogger;
import com.amazonaws.services.lambda.runtime.LambdaRuntime;
import io.micronaut.http.HttpHeaders;
import java.util.Calendar;

public class RuntimeContext
implements Context {
    private final HttpHeaders headers;

    public RuntimeContext(HttpHeaders headers) {
        this.headers = headers;
    }

    public String getAwsRequestId() {
        return (String)this.headers.get((CharSequence)"Lambda-Runtime-Aws-Request-Id");
    }

    public String getLogGroupName() {
        return this.getEnv("AWS_LAMBDA_LOG_GROUP_NAME");
    }

    public String getLogStreamName() {
        return this.getEnv("AWS_LAMBDA_LOG_STREAM_NAME");
    }

    public String getFunctionName() {
        return this.getEnv("AWS_LAMBDA_FUNCTION_NAME");
    }

    public String getFunctionVersion() {
        return this.getEnv("AWS_LAMBDA_FUNCTION_VERSION");
    }

    public String getInvokedFunctionArn() {
        return (String)this.headers.get((CharSequence)"Lambda-Runtime-Invoked-Function-Arn");
    }

    public CognitoIdentity getIdentity() {
        return null;
    }

    public ClientContext getClientContext() {
        return null;
    }

    public int getRemainingTimeInMillis() {
        String millis = (String)this.headers.get((CharSequence)"Lambda-Runtime-Deadline-Ms");
        try {
            if (millis != null) {
                long deadlineepoch = Long.parseLong(millis);
                long currentepoch = this.currentTime();
                Long remainingTime = deadlineepoch - currentepoch;
                return remainingTime.intValue();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 0;
    }

    public int getMemoryLimitInMB() {
        String memory = this.getEnv("AWS_LAMBDA_FUNCTION_MEMORY_SIZE");
        if (memory != null) {
            try {
                return Integer.parseInt(memory);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public LambdaLogger getLogger() {
        return LambdaRuntime.getLogger();
    }

    protected String getEnv(String name) {
        return System.getenv(name);
    }

    protected long currentTime() {
        return Calendar.getInstance().getTimeInMillis();
    }
}

