/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws.runtime;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.LambdaRuntime;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyResponseEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayV2HTTPEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayV2HTTPResponse;
import com.amazonaws.services.lambda.runtime.events.APIGatewayV2ProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayV2ProxyResponseEvent;
import com.amazonaws.services.lambda.runtime.events.ApplicationLoadBalancerRequestEvent;
import com.amazonaws.services.lambda.runtime.events.ApplicationLoadBalancerResponseEvent;
import com.amazonaws.services.lambda.runtime.events.CloudFrontEvent;
import com.amazonaws.services.lambda.runtime.events.CloudWatchLogsEvent;
import com.amazonaws.services.lambda.runtime.events.CodeCommitEvent;
import com.amazonaws.services.lambda.runtime.events.CognitoEvent;
import com.amazonaws.services.lambda.runtime.events.ConfigEvent;
import com.amazonaws.services.lambda.runtime.events.IoTButtonEvent;
import com.amazonaws.services.lambda.runtime.events.LexEvent;
import com.amazonaws.services.lambda.runtime.events.SNSEvent;
import com.amazonaws.services.lambda.runtime.events.SQSEvent;
import com.amazonaws.services.lambda.runtime.events.ScheduledEvent;
import io.micronaut.aws.ua.UserAgentProvider;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.context.ApplicationContextProvider;
import io.micronaut.context.env.CommandLinePropertySource;
import io.micronaut.context.env.PropertySource;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.cli.CommandLine;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.GenericTypeUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.function.aws.runtime.AwsLambdaRuntimeApi;
import io.micronaut.function.aws.runtime.RuntimeContext;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.client.BlockingHttpClient;
import io.micronaut.http.client.DefaultHttpClientConfiguration;
import io.micronaut.http.client.HttpClient;
import io.micronaut.json.JsonMapper;
import io.micronaut.logging.LogLevel;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Base64;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Predicate;

@TypeHint(accessType={TypeHint.AccessType.ALL_PUBLIC, TypeHint.AccessType.ALL_DECLARED_CONSTRUCTORS, TypeHint.AccessType.ALL_PUBLIC_CONSTRUCTORS, TypeHint.AccessType.ALL_DECLARED_METHODS, TypeHint.AccessType.ALL_DECLARED_FIELDS, TypeHint.AccessType.ALL_PUBLIC_METHODS, TypeHint.AccessType.ALL_PUBLIC_FIELDS}, value={APIGatewayV2HTTPEvent.class, APIGatewayV2HTTPEvent.RequestContext.Authorizer.class, APIGatewayV2HTTPEvent.RequestContext.Authorizer.JWT.class, APIGatewayV2HTTPEvent.RequestContext.Http.class, APIGatewayV2HTTPEvent.RequestContext.IAM.class, APIGatewayV2HTTPEvent.RequestContext.CognitoIdentity.class, APIGatewayV2HTTPEvent.RequestContext.class, APIGatewayV2HTTPResponse.class, ApplicationLoadBalancerRequestEvent.class, ApplicationLoadBalancerResponseEvent.class, APIGatewayProxyRequestEvent.class, APIGatewayProxyRequestEvent.ProxyRequestContext.class, APIGatewayProxyRequestEvent.RequestIdentity.class, APIGatewayProxyResponseEvent.class, ScheduledEvent.class, APIGatewayV2ProxyRequestEvent.class, APIGatewayV2ProxyResponseEvent.class, CloudFrontEvent.class, CloudWatchLogsEvent.class, CodeCommitEvent.class, CognitoEvent.class, ConfigEvent.class, IoTButtonEvent.class, LexEvent.class, SNSEvent.class, SQSEvent.class})
public abstract class AbstractMicronautLambdaRuntime<RequestType, ResponseType, HandlerRequestType, HandlerResponseType>
implements ApplicationContextProvider,
AwsLambdaRuntimeApi {
    @Nullable
    protected String userAgent;
    protected Object handler;
    protected final Class<RequestType> requestType = this.initTypeArgument(0);
    protected final Class<ResponseType> responseType = this.initTypeArgument(1);
    protected final Class<HandlerRequestType> handlerRequestType = this.initTypeArgument(2);
    protected final Class<HandlerResponseType> handlerResponseType = this.initTypeArgument(3);

    public void run(String ... args) throws MalformedURLException {
        URL runtimeApiURL = this.lookupRuntimeApiEndpoint();
        this.logn(LogLevel.DEBUG, "runtime endpoint: ", runtimeApiURL);
        Predicate<URL> loopUntil = url -> true;
        this.startRuntimeApiEventLoop(runtimeApiURL, loopUntil, args);
    }

    protected void populateUserAgent() {
        if (this.getApplicationContext().containsBean(UserAgentProvider.class)) {
            UserAgentProvider userAgentProvider = (UserAgentProvider)this.getApplicationContext().getBean(UserAgentProvider.class);
            this.userAgent = userAgentProvider.userAgent();
        }
    }

    protected void validateHandler() throws ConfigurationException {
        if (this.handler == null) {
            throw new ConfigurationException("no handler instantiated. Override either createHandler() or createRequestStreamHandler() or annotate your Handler class with @Introspected");
        }
        if (!(this.handler instanceof RequestHandler) && !(this.handler instanceof RequestStreamHandler)) {
            throw new ConfigurationException("handler must be of type com.amazonaws.services.lambda.runtime.RequestHandler or com.amazonaws.services.lambda.runtime.RequestStreamHandler");
        }
    }

    public ApplicationContext getApplicationContext() {
        Object object = this.handler;
        if (object instanceof ApplicationContextProvider) {
            ApplicationContextProvider applicationContextProvider = (ApplicationContextProvider)object;
            return applicationContextProvider.getApplicationContext();
        }
        return null;
    }

    public ApplicationContextBuilder createApplicationContextBuilderWithArgs(String ... args) {
        CommandLine commandLine = CommandLine.parse((String[])args);
        return ApplicationContext.builder().environments(new String[]{"lambda"}).propertySources(new PropertySource[]{new CommandLinePropertySource(commandLine)});
    }

    @Nullable
    protected RequestHandler<HandlerRequestType, HandlerResponseType> createRequestHandler(String ... args) {
        return null;
    }

    @Nullable
    protected RequestStreamHandler createRequestStreamHandler(String ... args) {
        return null;
    }

    @Nullable
    protected Object createHandler(String ... args) {
        RequestHandler<HandlerRequestType, HandlerResponseType> requestHandler = this.createRequestHandler(args);
        if (requestHandler != null) {
            return requestHandler;
        }
        RequestStreamHandler requestStreamHandler = this.createRequestStreamHandler(args);
        if (requestStreamHandler != null) {
            return requestStreamHandler;
        }
        return this.createEnvironmentHandler();
    }

    @Nullable
    protected Object createEnvironmentHandler() {
        String localHandler = this.getEnv("_HANDLER");
        this.logn(LogLevel.DEBUG, "Handler: ", localHandler);
        if (localHandler != null) {
            Optional<Class<?>> handlerClassOptional = this.parseHandlerClass(localHandler);
            this.logn(LogLevel.WARN, "No handler Class parsed for ", localHandler);
            if (handlerClassOptional.isPresent()) {
                this.log(LogLevel.DEBUG, "Handler Class parsed. Instantiating it via introspection\n");
                Class<?> handlerClass = handlerClassOptional.get();
                BeanIntrospection introspection = BeanIntrospection.getIntrospection(handlerClass);
                return introspection.instantiate();
            }
        }
        return null;
    }

    protected Optional<Class<?>> parseHandlerClass(@NonNull String handler) {
        String[] arr = handler.split("::");
        if (arr.length > 0) {
            return ClassUtils.forName((String)arr[0], null);
        }
        return Optional.empty();
    }

    @Nullable
    protected ResponseType createResponse(HandlerResponseType handlerResponse) {
        if (this.handlerResponseType == this.responseType) {
            this.log(LogLevel.TRACE, "HandlerResponseType and ResponseType are identical\n");
            return (ResponseType)handlerResponse;
        }
        if (this.responseType == APIGatewayProxyResponseEvent.class || this.responseType == APIGatewayV2HTTPResponse.class) {
            this.log(LogLevel.TRACE, "response type is APIGatewayProxyResponseEvent\n");
            try {
                byte[] json = this.serializeAsByteArray(handlerResponse);
                if (json != null) {
                    return (ResponseType)this.respond(HttpStatus.OK, json, "application/json");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return (ResponseType)this.respond(HttpStatus.BAD_REQUEST, "Could not serialize response as json".getBytes(), "text/plain");
        }
        return null;
    }

    protected APIGatewayProxyResponseEvent respond(HttpStatus status, byte[] body, String contentType) {
        APIGatewayProxyResponseEvent response = new APIGatewayProxyResponseEvent();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", contentType);
        response.setHeaders(headers);
        response.setIsBase64Encoded(Boolean.valueOf(true));
        response.setBody(Base64.getEncoder().encodeToString(body));
        response.setStatusCode(Integer.valueOf(status.getCode()));
        this.logn(LogLevel.TRACE, "response: ", status.getCode(), " content type: ", headers.get("Content-Type"), " message ", body);
        return response;
    }

    @Nullable
    protected HandlerRequestType createHandlerRequest(RequestType request) throws IOException {
        if (this.requestType == this.handlerRequestType) {
            return (HandlerRequestType)request;
        }
        if (request instanceof ApplicationLoadBalancerRequestEvent) {
            ApplicationLoadBalancerRequestEvent applicationLoadBalancerRequestEvent = (ApplicationLoadBalancerRequestEvent)request;
            this.log(LogLevel.TRACE, "request of type ApplicationLoadBalancerRequestEvent");
            String content = applicationLoadBalancerRequestEvent.getBody();
            return this.valueFromContent(content, this.handlerRequestType);
        }
        if (request instanceof APIGatewayProxyRequestEvent) {
            APIGatewayProxyRequestEvent apiGatewayProxyRequestEvent = (APIGatewayProxyRequestEvent)request;
            this.log(LogLevel.TRACE, "request of type APIGatewayProxyRequestEvent");
            String content = apiGatewayProxyRequestEvent.getBody();
            return this.valueFromContent(content, this.handlerRequestType);
        }
        if (request instanceof APIGatewayV2HTTPEvent) {
            APIGatewayV2HTTPEvent apiGatewayV2HTTPEvent = (APIGatewayV2HTTPEvent)request;
            this.log(LogLevel.TRACE, "request of type APIGatewayV2HTTPEvent\n");
            String content = apiGatewayV2HTTPEvent.getBody();
            return this.valueFromContent(content, this.handlerRequestType);
        }
        this.log(LogLevel.TRACE, "createHandlerRequest return null\n");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startRuntimeApiEventLoop(@NonNull URL runtimeApiURL, @NonNull Predicate<URL> loopUntil, String ... args) {
        block16: {
            try {
                this.handler = this.createHandler(args);
                this.validateHandler();
                ApplicationContext applicationContext = this.getApplicationContext();
                if (applicationContext == null) {
                    throw new ConfigurationException("Application Context is null");
                }
                this.populateUserAgent();
                DefaultHttpClientConfiguration config = new DefaultHttpClientConfiguration();
                config.setReadIdleTimeout(null);
                config.setReadTimeout(null);
                config.setConnectTimeout(null);
                HttpClient endpointClient = (HttpClient)applicationContext.createBean(HttpClient.class, new Object[]{runtimeApiURL, config});
                BlockingHttpClient blockingHttpClient = endpointClient.toBlocking();
                block9: while (true) {
                    while (loopUntil.test(runtimeApiURL)) {
                        MutableHttpRequest nextInvocationHttpRequest = HttpRequest.GET((String)"/2018-06-01/runtime/invocation/next");
                        applicationContext.findBean(UserAgentProvider.class).ifPresent(userAgentProvider -> nextInvocationHttpRequest.header((CharSequence)"User-Agent", (CharSequence)userAgentProvider.userAgent()));
                        HttpResponse response = blockingHttpClient.exchange((HttpRequest)nextInvocationHttpRequest, Argument.of(this.requestType));
                        Object request = response.body();
                        if (request == null) continue;
                        this.logn(LogLevel.DEBUG, "request body ", request);
                        HandlerRequestType handlerRequest = this.createHandlerRequest(request);
                        HttpHeaders headers = response.getHeaders();
                        this.propagateTraceId(headers);
                        RuntimeContext context = new RuntimeContext(headers);
                        String requestId = context.getAwsRequestId();
                        this.logn(LogLevel.DEBUG, "request id ", requestId, " found");
                        try {
                            if (StringUtils.isNotEmpty((CharSequence)requestId)) {
                                this.log(LogLevel.TRACE, "invoking handler\n");
                                Object handlerResponse = null;
                                if (this.handler instanceof RequestHandler) {
                                    handlerResponse = ((RequestHandler)this.handler).handleRequest(handlerRequest, (Context)context);
                                }
                                this.log(LogLevel.TRACE, "handler response received\n");
                                Object functionResponse = handlerResponse == null || handlerResponse instanceof Void ? null : this.createResponse(handlerResponse);
                                this.log(LogLevel.TRACE, "sending function response\n");
                                blockingHttpClient.exchange(this.decorateWithUserAgent(this.invocationResponseRequest(requestId, functionResponse == null ? "" : functionResponse)));
                                continue block9;
                            }
                            this.log(LogLevel.WARN, "request id is empty\n");
                            continue block9;
                        }
                        catch (Throwable e) {
                            StringWriter sw = new StringWriter();
                            e.printStackTrace(new PrintWriter(sw));
                            this.logn(LogLevel.WARN, "Invocation with requestId [", requestId, "] failed: ", e.getMessage(), sw);
                            try {
                                blockingHttpClient.exchange(this.decorateWithUserAgent(this.invocationErrorRequest(requestId, e.getMessage(), null, null)));
                                continue block9;
                            }
                            catch (Throwable throwable) {
                            }
                        }
                    }
                    break block16;
                    {
                        continue block9;
                        break;
                    }
                    break;
                }
                finally {
                    Object object = this.handler;
                    if (object instanceof Closeable) {
                        Closeable closeable = (Closeable)object;
                        closeable.close();
                    }
                    if (endpointClient != null) {
                        endpointClient.close();
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.logn(LogLevel.ERROR, "Request loop failed with: ", e.getMessage());
                this.reportInitializationError(runtimeApiURL, e);
            }
        }
    }

    protected HttpRequest decorateWithUserAgent(HttpRequest<?> request) {
        if (this.userAgent != null && request instanceof MutableHttpRequest) {
            MutableHttpRequest mutableHttpRequest = (MutableHttpRequest)request;
            return mutableHttpRequest.header((CharSequence)"User-Agent", (CharSequence)this.userAgent);
        }
        return request;
    }

    protected void propagateTraceId(HttpHeaders headers) {
        String traceId = (String)headers.get((CharSequence)"Lambda-Runtime-Trace-Id");
        this.logn(LogLevel.DEBUG, "Trace id: ", traceId, Character.valueOf('\n'));
        if (StringUtils.isNotEmpty((CharSequence)traceId)) {
            System.setProperty("com.amazonaws.xray.traceHeader", traceId);
        }
    }

    protected void reportInitializationError(URL runtimeApiURL, Throwable e) {
        try (HttpClient endpointClient = HttpClient.create((URL)runtimeApiURL);){
            endpointClient.toBlocking().exchange(this.decorateWithUserAgent(this.initializationErrorRequest(e.getMessage(), null, null)));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Nullable
    protected byte[] serializeAsByteArray(Object value) throws IOException {
        if (value == null) {
            return null;
        }
        ApplicationContext applicationContext = this.getApplicationContext();
        if (applicationContext != null && applicationContext.containsBean(JsonMapper.class)) {
            JsonMapper jsonMapper = (JsonMapper)applicationContext.getBean(JsonMapper.class);
            return jsonMapper.writeValueAsBytes(value);
        }
        return null;
    }

    @Nullable
    protected <T> T valueFromContent(String content, Class<T> valueType) throws IOException {
        if (content == null) {
            return null;
        }
        ApplicationContext applicationContext = this.getApplicationContext();
        if (applicationContext != null && applicationContext.containsBean(JsonMapper.class)) {
            JsonMapper objectMapper = (JsonMapper)applicationContext.getBean(JsonMapper.class);
            return (T)objectMapper.readValue(content, Argument.of(valueType));
        }
        return null;
    }

    protected String getEnv(String name) {
        return System.getenv(name);
    }

    protected void log(LogLevel level, String msg) {
        if (this.shouldLog(level)) {
            LambdaRuntime.getLogger().log(msg);
        }
    }

    protected LogLevel getLogLevel() {
        return LogLevel.WARN;
    }

    protected void logn(LogLevel logLevel, String msg) {
        this.logn(logLevel, msg, Character.valueOf('\n'));
    }

    protected void logn(LogLevel level, Object ... messageParts) {
        if (!this.shouldLog(level)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (Object part : messageParts) {
            sb.append(part);
        }
        sb.append('\n');
        LambdaRuntime.getLogger().log(sb.toString());
    }

    protected boolean shouldLog(LogLevel level) {
        if (level == LogLevel.ALL) {
            return true;
        }
        if (level == LogLevel.OFF || level == LogLevel.NOT_SPECIFIED) {
            return false;
        }
        return this.getLogLevel().ordinal() <= level.ordinal();
    }

    private URL lookupRuntimeApiEndpoint() throws MalformedURLException {
        String runtimeApiEndpoint = this.getEnv("AWS_LAMBDA_RUNTIME_API");
        if (StringUtils.isEmpty((CharSequence)runtimeApiEndpoint)) {
            throw new IllegalStateException("Missing AWS_LAMBDA_RUNTIME_API environment variable. Custom runtime can only be run within AWS Lambda environment.");
        }
        return new URL("http://" + runtimeApiEndpoint);
    }

    private Class initTypeArgument(int index) {
        Object[] args = GenericTypeUtils.resolveSuperTypeGenericArguments(this.getClass(), AbstractMicronautLambdaRuntime.class);
        if (ArrayUtils.isNotEmpty((Object[])args) && args.length > index) {
            return args[index];
        }
        return Object.class;
    }
}

