/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws.test;

import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.function.aws.LambdaApplicationContextBuilder;
import io.micronaut.function.aws.test.annotation.MicronautLambdaTest;
import io.micronaut.test.annotation.MicronautTestValue;
import io.micronaut.test.extensions.junit5.MicronautJunit5Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

public class MicronautLambdaJunit5Extension
extends MicronautJunit5Extension {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{MicronautLambdaJunit5Extension.class});

    protected void postProcessBuilder(ApplicationContextBuilder builder) {
        LambdaApplicationContextBuilder.setLambdaConfiguration((ApplicationContextBuilder)builder);
    }

    protected MicronautTestValue buildMicronautTestValue(Class<?> testClass) {
        return AnnotationSupport.findAnnotation(testClass, MicronautLambdaTest.class).map(this::buildValueObject).orElse(null);
    }

    private MicronautTestValue buildValueObject(MicronautLambdaTest micronautTest) {
        return new MicronautTestValue(micronautTest.application(), micronautTest.environments(), micronautTest.packages(), micronautTest.propertySources(), micronautTest.rollback(), micronautTest.transactional(), micronautTest.rebuildContext(), (Class[])micronautTest.contextBuilder(), micronautTest.transactionMode(), micronautTest.startApplication(), micronautTest.resolveParameters());
    }

    protected boolean hasExpectedAnnotations(Class<?> testClass) {
        return AnnotationSupport.isAnnotated(testClass, MicronautLambdaTest.class);
    }

    protected ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getRoot().getStore(NAMESPACE);
    }
}

