/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws;

import com.amazonaws.services.lambda.runtime.ClientContext;
import com.amazonaws.services.lambda.runtime.CognitoIdentity;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.LambdaLogger;
import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.function.aws.LambdaContextFactory;
import jakarta.inject.Singleton;

@Singleton
public class DefaultLambdaContextFactory
implements LambdaContextFactory {
    private final BeanContext beanContext;

    public DefaultLambdaContextFactory(BeanContext beanContext) {
        this.beanContext = beanContext;
    }

    @Override
    public void registerSingletons(@NonNull Context context) {
        CognitoIdentity identity;
        ClientContext clientContext;
        this.beanContext.registerSingleton((Object)context);
        LambdaLogger logger = context.getLogger();
        if (logger != null) {
            this.beanContext.registerSingleton((Object)logger);
        }
        if ((clientContext = context.getClientContext()) != null) {
            this.beanContext.registerSingleton((Object)clientContext);
        }
        if ((identity = context.getIdentity()) != null) {
            this.beanContext.registerSingleton((Object)identity);
        }
    }
}

