/*
 * Copyright 2017-2020 original authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.micronaut.function.aws;

import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.context.DefaultApplicationContextBuilder;
import io.micronaut.context.env.Environment;

/**
 * An {@link io.micronaut.context.ApplicationContextBuilder} for AWS Lambda environments.
 *
 * @author ttzn
 * @since 2.3.0
 */
public class LambdaApplicationContextBuilder extends DefaultApplicationContextBuilder {
    public LambdaApplicationContextBuilder() {
        setLambdaConfiguration(this);
    }

    public static void setLambdaConfiguration(ApplicationContextBuilder builder) {
        builder
            .environments(Environment.FUNCTION, MicronautLambdaContext.ENVIRONMENT_LAMBDA)
            .eagerInitConfiguration(true)
            .eagerInitSingletons(true);
    }
}
