/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws;

import com.amazonaws.services.lambda.runtime.Context;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextProvider;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.function.aws.DiagnosticInfoPopulator;
import io.micronaut.function.aws.LambdaContextFactory;

public final class HandlerUtils {
    private HandlerUtils() {
    }

    public static void configureWithContext(@NonNull ApplicationContextProvider applicationContextProvider, @Nullable Context lambdaContext) {
        ApplicationContext applicationContext = applicationContextProvider.getApplicationContext();
        DiagnosticInfoPopulator mdcPopulator = null;
        if (applicationContext.containsBean(DiagnosticInfoPopulator.class)) {
            mdcPopulator = (DiagnosticInfoPopulator)applicationContext.getBean(DiagnosticInfoPopulator.class);
        }
        if (lambdaContext != null) {
            if (applicationContext.containsBean(LambdaContextFactory.class)) {
                ((LambdaContextFactory)applicationContext.getBean(LambdaContextFactory.class)).registerSingletons(lambdaContext);
            }
            if (mdcPopulator != null) {
                mdcPopulator.populateMappingDiagnosticContextValues(lambdaContext);
            }
        }
        if (mdcPopulator != null) {
            mdcPopulator.populateMappingDiagnosticContextWithXrayTraceId();
        }
    }
}

