/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.context.ApplicationContextProvider;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.reflect.GenericTypeUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.function.aws.HandlerUtils;
import io.micronaut.function.aws.LambdaApplicationContextBuilder;
import io.micronaut.function.aws.MicronautLambdaContext;
import io.micronaut.function.aws.XRayUtils;
import io.micronaut.function.executor.AbstractFunctionExecutor;
import java.util.Optional;
import org.slf4j.MDC;

public abstract class MicronautRequestHandler<I, O>
extends AbstractFunctionExecutor<I, O, Context>
implements RequestHandler<I, O>,
MicronautLambdaContext {
    public static final String ENV_X_AMZN_TRACE_ID = "_X_AMZN_TRACE_ID";
    public static final String LAMBDA_TRACE_HEADER_PROP = "com.amazonaws.xray.traceHeader";
    @Deprecated
    public static final String MDC_DEFAULT_AWS_REQUEST_ID = "AWSRequestId";
    @Deprecated
    public static final String MDC_DEFAULT_FUNCTION_NAME = "AWSFunctionName";
    @Deprecated
    public static final String MDC_DEFAULT_FUNCTION_VERSION = "AWSFunctionVersion";
    @Deprecated
    public static final String MDC_DEFAULT_FUNCTION_ARN = "AWSFunctionArn";
    @Deprecated
    public static final String MDC_DEFAULT_FUNCTION_MEMORY_SIZE = "AWSFunctionMemoryLimit";
    @Deprecated
    public static final String MDC_DEFAULT_FUNCTION_REMAINING_TIME = "AWSFunctionRemainingTime";
    @Deprecated
    public static final String MDC_DEFAULT_XRAY_TRACE_ID = "AWS-XRAY-TRACE-ID";
    private final Class<I> inputType = this.initTypeArgument();

    public MicronautRequestHandler() {
        this.buildApplicationContext(null);
        this.injectIntoApplicationContext();
    }

    public MicronautRequestHandler(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.startEnvironment(applicationContext);
        this.injectIntoApplicationContext();
    }

    public MicronautRequestHandler(ApplicationContextBuilder applicationContextBuilder) {
        this(applicationContextBuilder.build());
    }

    private void injectIntoApplicationContext() {
        this.applicationContext.inject((Object)this);
    }

    public final O handleRequest(I input, Context context) {
        HandlerUtils.configureWithContext((ApplicationContextProvider)this, context);
        if (!this.inputType.isInstance(input)) {
            input = this.convertInput(input);
        }
        return (O)this.execute(input);
    }

    @Deprecated
    protected void populateMappingDiagnosticContextValues(@NonNull Context context) {
    }

    @Deprecated
    protected void mdcput(@NonNull String key, @NonNull String val) throws IllegalArgumentException {
        MDC.put((String)key, (String)val);
    }

    @Deprecated
    protected void populateMappingDiagnosticContextWithXrayTraceId() {
    }

    @NonNull
    @Deprecated
    protected static Optional<String> parseXrayTraceId() {
        return XRayUtils.parseXrayTraceId();
    }

    protected I convertInput(Object input) {
        ArgumentConversionContext cc = ConversionContext.of(this.inputType);
        Optional converted = this.applicationContext.getConversionService().convert(input, cc);
        return (I)converted.orElseThrow(() -> new IllegalArgumentException("Unconvertible input: " + input, cc.getLastError().map(ConversionError::getCause).orElse(null)));
    }

    protected ApplicationContext buildApplicationContext(Context context) {
        this.applicationContext = super.buildApplicationContext((Object)context);
        this.startEnvironment(this.applicationContext);
        return this.applicationContext;
    }

    @NonNull
    protected ApplicationContextBuilder newApplicationContextBuilder() {
        return new LambdaApplicationContextBuilder();
    }

    @Deprecated
    static void registerContextBeans(Context context, ApplicationContext applicationContext) {
    }

    private Class initTypeArgument() {
        Object[] args = GenericTypeUtils.resolveSuperTypeGenericArguments(this.getClass(), MicronautRequestHandler.class);
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            return args[0];
        }
        return Object.class;
    }
}

