/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.context.ApplicationContextProvider;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.function.aws.HandlerUtils;
import io.micronaut.function.aws.LambdaApplicationContextBuilder;
import io.micronaut.function.aws.MicronautLambdaContext;
import io.micronaut.function.executor.StreamFunctionExecutor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MicronautRequestStreamHandler
extends StreamFunctionExecutor<Context>
implements RequestStreamHandler,
MicronautLambdaContext {
    @Nullable
    private String ctxFunctionName;

    public MicronautRequestStreamHandler() {
        this.buildApplicationContext(null);
    }

    public MicronautRequestStreamHandler(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void handleRequest(InputStream input, OutputStream output, Context context) throws IOException {
        if (context != null) {
            this.ctxFunctionName = context.getFunctionName();
        }
        HandlerUtils.configureWithContext((ApplicationContextProvider)this, context);
        this.execute(input, output, context);
    }

    protected ApplicationContext buildApplicationContext(Context context) {
        return super.buildApplicationContext((Object)context);
    }

    @NonNull
    protected ApplicationContextBuilder newApplicationContextBuilder() {
        return new LambdaApplicationContextBuilder();
    }

    protected String resolveFunctionName(Environment env) {
        String functionName = super.resolveFunctionName(env);
        return functionName != null ? functionName : this.ctxFunctionName;
    }

    public void close() {
    }
}

